/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.event;

import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.client.particle.PetalParticle;
import cy.jdkdigital.productivetrees.client.render.block.PollinatedLeavesBlockEntityRenderer;
import cy.jdkdigital.productivetrees.client.render.block.StripperBlockEntityRenderer;
import cy.jdkdigital.productivetrees.client.render.block.TimeTravellerDisplayBlockEntityRenderer;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.inventory.screen.PollenSifterScreen;
import cy.jdkdigital.productivetrees.inventory.screen.SawmillScreen;
import cy.jdkdigital.productivetrees.inventory.screen.StripperScreen;
import cy.jdkdigital.productivetrees.inventory.screen.WoodworkerScreen;
import cy.jdkdigital.productivetrees.registry.ClientRegistration;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="productivetrees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ClientRegistration.PETAL_PARTICLES.get(), PetalParticle.Provider::new);
    }

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)TreeRegistrator.STRIPPER_MENU.get()), StripperScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TreeRegistrator.SAWMILL_MENU.get()), SawmillScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TreeRegistrator.WOOD_WORKER_MENU.get()), WoodworkerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)TreeRegistrator.POLLEN_SIFTER_MENU.get()), PollenSifterScreen::new);
            ItemProperties.register((Item)((Item)TreeRegistrator.FUSTIC.get()), (ResourceLocation)new ResourceLocation("count"), (stack, world, entity, i) -> stack.m_41613_());
        });
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.POLLINATED_LEAVES_BLOCK_ENTITY.get(), PollinatedLeavesBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.STRIPPER_BLOCK_ENTITY.get(), StripperBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.TIME_TRAVELLER_DISPLAY_BLOCK_ENTITY.get(), TimeTravellerDisplayBlockEntityRenderer::new);
        TreeFinder.trees.forEach((id, treeObject) -> {
            event.registerBlockEntityRenderer(TreeRegistrator.SIGN_BE.get(), SignRenderer::new);
            event.registerBlockEntityRenderer(TreeRegistrator.HANGING_SIGN_BE.get(), HangingSignRenderer::new);
        });
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Block")) {
                return TreeUtil.getLeafColor((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.m_41783_().m_128461_("Block"))));
            }
            return FoliageColor.m_46113_();
        }, new ItemLike[]{(ItemLike)TreeRegistrator.POLLEN.get()});
        TreeFinder.trees.forEach((id, treeObject) -> {
            event.register((stack, tintIndex) -> tintIndex == 0 ? ColorUtil.getCacheColor((String)treeObject.getLeafColor()) : (treeObject.hasFruit() && tintIndex == 2 ? ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor()) : ColorUtil.getCacheColor((String)treeObject.getLogColor())), new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_sapling"), TreeUtil.getBlock(treeObject.getId(), "_potted_sapling")});
            if (ModList.get().isLoaded("productivebees") && treeObject.getStyle().hiveStyle() != null && treeObject.tintHives()) {
                event.register((stack, tintIndex) -> ColorUtil.getCacheColor((String)treeObject.getPlankColor()), new ItemLike[]{(ItemLike)ForgeRegistries.BLOCKS.getValue(id.m_247266_(p -> "advanced_" + p + "_beehive")), (ItemLike)ForgeRegistries.BLOCKS.getValue(id.m_247266_(p -> "expansion_box_" + p))});
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> {
            BlockEntity be;
            if (lightReader != null && pos != null && (be = lightReader.m_7702_(pos)) instanceof PollinatedLeavesBlockEntity) {
                PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)be;
                int colorA = TreeUtil.getLeafColor(pollinatedLeavesBlockEntity.getLeafA(), lightReader, pos);
                int colorB = TreeUtil.getLeafColor(pollinatedLeavesBlockEntity.getLeafB(), lightReader, pos);
                return ColorUtil.blend((int)colorA, (int)colorB, (float)0.5f);
            }
            return FoliageColor.m_46113_();
        }, new Block[]{(Block)TreeRegistrator.POLLINATED_LEAVES.get()});
        TreeFinder.trees.forEach((id, treeObject) -> {
            event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 ? ColorUtil.getCacheColor((String)treeObject.getLeafColor()) : (treeObject.hasFruit() && tintIndex == 2 ? ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor()) : ColorUtil.getCacheColor((String)treeObject.getLogColor())), new Block[]{TreeUtil.getBlock(treeObject.getId(), "_sapling"), TreeUtil.getBlock(treeObject.getId(), "_potted_sapling")});
            if (ModList.get().isLoaded("productivebees") && treeObject.getStyle().hiveStyle() != null && treeObject.tintHives()) {
                event.register((blockState, lightReader, pos, tintIndex) -> ColorUtil.getCacheColor((String)treeObject.getPlankColor()), new Block[]{(Block)ForgeRegistries.BLOCKS.getValue(id.m_247266_(p -> "advanced_" + p + "_beehive")), (Block)ForgeRegistries.BLOCKS.getValue(id.m_247266_(p -> "expansion_box_" + p))});
            }
        });
    }
}

