/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.inventory.StripperContainer;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StripperBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_AXE = 2;
    public static int SLOT_BARK = 3;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(4, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            if (!(slot != SLOT_OUT && slot != SLOT_BARK || stack.m_204117_(ModTags.STRIPPER_TOOLS))) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                if (currentOutStack.m_41619_()) {
                    return true;
                }
                if (currentOutStack.m_41613_() < currentOutStack.m_41741_()) {
                    return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentOutStack) && !StripperBlockEntity.this.canProcess(stack);
                }
            }
            return false;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_AXE || slot == SLOT_IN;
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            if (slot == SLOT_IN && stack.m_204117_(ItemTags.f_13182_) || slot == SLOT_AXE && stack.m_204117_(ModTags.STRIPPER_TOOLS)) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                return currentOutStack.m_41619_() || currentOutStack.m_41613_() < currentOutStack.m_41741_() && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentOutStack);
            }
            return false;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT, SLOT_BARK};
        }

        protected void onContentsChanged(int slot) {
            Level level;
            super.onContentsChanged(slot);
            if (slot == SLOT_AXE && (level = StripperBlockEntity.this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7260_(StripperBlockEntity.this.m_58899_(), StripperBlockEntity.this.m_58900_(), StripperBlockEntity.this.m_58900_(), 2);
            }
        }
    });

    public StripperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.STRIPPER_BLOCK_ENTITY.get(), pos, state);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        return !stripped.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stripped);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)((Block)TreeRegistrator.STRIPPER.get()).m_7705_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StripperBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % 10 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockEntity.inventoryHandler.ifPresent(inv -> {
                ItemStack strippedLogItem;
                ItemStack log = inv.getStackInSlot(SLOT_IN);
                ItemStack axe = inv.getStackInSlot(SLOT_AXE);
                ItemStack output = inv.getStackInSlot(SLOT_OUT);
                if (!log.m_41619_() && !axe.m_41619_() && output.m_41613_() < output.m_41741_() && !(strippedLogItem = TreeUtil.getStrippedItem(blockEntity, serverLevel, log)).m_41619_() && inv.insertItem(SLOT_OUT, strippedLogItem, false).m_41619_()) {
                    ProductiveLogBlock logBlock;
                    TreeObject treeObject;
                    BlockItem blockItem;
                    Block patt5615$temp;
                    Item patt5560$temp = log.m_41720_();
                    if (patt5560$temp instanceof BlockItem && (patt5615$temp = (blockItem = (BlockItem)patt5560$temp).m_40614_()) instanceof ProductiveLogBlock && (treeObject = TreeUtil.getTree((Block)(logBlock = (ProductiveLogBlock)patt5615$temp))) != null && !treeObject.getStripDrop().get().m_41619_()) {
                        inv.insertItem(SLOT_BARK, treeObject.getStripDrop().get().m_41777_(), false);
                    }
                    log.m_41774_(1);
                    if (axe.m_41763_()) {
                        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(TreeUtil.STRIPPER_UUID, "stripper"));
                        axe.m_41622_(1, (LivingEntity)fakePlayer, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
            });
        }
    }

    public ItemStack getAxe() {
        return this.inventoryHandler.map(h -> h.getStackInSlot(SLOT_AXE)).orElse(ItemStack.f_41583_);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new StripperContainer(windowId, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

