/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;

public class ProductiveFruitBlock
extends ProductiveLeavesBlock {
    public ProductiveFruitBlock(BlockBehaviour.Properties properties, TreeObject treeObject) {
        super(properties, treeObject);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ProductiveFruitBlock.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        super.m_7926_(blockStateBuilder);
        blockStateBuilder.m_61104_(new Property[]{ProductiveFruitBlock.getAgeProperty()});
    }

    public boolean m_8133_(BlockState blockState, Level level, BlockPos blockPos, int p_49229_, int p_49230_) {
        super.m_8133_(blockState, level, blockPos, p_49229_, p_49230_);
        BlockEntity blockentity = level.m_7702_(blockPos);
        return blockentity != null && blockentity.m_7531_(p_49229_, p_49230_);
    }

    public static IntegerProperty getAgeProperty() {
        return BlockStateProperties.f_61409_;
    }

    public static int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)ProductiveFruitBlock.getAgeProperty());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.treeObject.getFruit().getItem().m_41720_());
    }

    public BlockState getStateForAge(BlockState currentState, int age) {
        return (BlockState)currentState.m_61124_((Property)ProductiveFruitBlock.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public static boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)ProductiveFruitBlock.getAgeProperty()) >= ProductiveFruitBlock.getMaxAge();
    }

    public boolean m_6724_(BlockState blockState) {
        return !ProductiveFruitBlock.isMaxAge(blockState);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        int i;
        super.m_213898_(state, level, blockPos, random);
        int light = level.m_45524_(blockPos, 0);
        if (light >= this.treeObject.getGrowthConditions().minLight() && light <= this.treeObject.getGrowthConditions().maxLight() && (i = this.getAge(state)) < ProductiveFruitBlock.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockPos, (BlockState)state, (random.m_188503_((int)(25.0f / this.treeObject.getFruit().growthSpeed()) + 1) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(blockPos, this.getStateForAge(state, i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (ProductiveFruitBlock.isMaxAge(state)) {
            ProductiveFruitBlock.m_49840_((Level)level, (BlockPos)pos.m_121945_(hitResult.m_82434_()), (ItemStack)this.treeObject.getFruit().getItem());
            level.m_7731_(pos, this.getStateForAge(state, 0), 2);
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_150930_(Items.f_42499_)) {
            int i = this.getAge(state);
            level.m_7731_(pos, this.getStateForAge(state, i + 1), 2);
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

