/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.loot.LootFunc;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModLootTablesProvider
extends LootTableProvider {
    public ModLootTablesProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTablePNC::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(MechanicVillagerChestLootProvider::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(CustomDungeonLootProvider::new, LootContextParamSets.f_81411_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationresults) {
    }

    private static class CustomDungeonLootProvider
    implements LootTableSubProvider {
        private CustomDungeonLootProvider() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder commonPool = LootPool.m_79043_();
            commonPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_INGOT.get(), 10, 1, 3)).m_79076_(this.createEntry((ItemLike)ModBlocks.COMPRESSED_STONE.get(), 10, 5, 10)).m_79076_(this.createEntry((ItemLike)ModItems.LOGISTICS_CORE.get(), 3, 1, 1)).m_79076_(this.createEntry((ItemLike)ModBlocks.PRESSURE_TUBE.get(), 3, 8, 8)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(20));
            LootTable.Builder commonTable = LootTable.m_79147_();
            commonTable.m_79161_(commonPool);
            consumer.accept(PneumaticRegistry.RL("custom/common_dungeon_loot"), commonTable);
            LootPool.Builder uncommonPool = LootPool.m_79043_();
            uncommonPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_(this.createEntry((ItemLike)ModItems.VORTEX_CANNON.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.SPAWNER_AGITATOR.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_BOOTS.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_LEGGINGS.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_CHESTPLATE.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_HELMET.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.TRANSISTOR.get(), 1, 1, 4)).m_79076_(this.createEntry((ItemLike)ModItems.CAPACITOR.get(), 1, 1, 4)).m_79076_(this.createEntry((ItemLike)ModItems.PNEUMATIC_CYLINDER.get(), 1, 2, 3)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(10));
            LootTable.Builder uncommonTable = LootTable.m_79147_();
            uncommonTable.m_79161_(uncommonPool);
            consumer.accept(PneumaticRegistry.RL("custom/uncommon_dungeon_loot"), uncommonTable);
            LootPool.Builder rarePool = LootPool.m_79043_();
            rarePool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(this.createEntry((ItemLike)ModItems.STOP_WORM.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.NUKE_VIRUS.get(), 1, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.GUN_AMMO_AP.get(), 1, 1, 1)).m_79076_(this.ammo((ItemLike)ModItems.GUN_AMMO_FREEZING.get())).m_79076_(this.ammo((ItemLike)ModItems.GUN_AMMO_WEIGHTED.get())).m_79076_(this.ammo((ItemLike)ModItems.GUN_AMMO_INCENDIARY.get())).m_79076_(this.ammo((ItemLike)ModItems.GUN_AMMO_EXPLOSIVE.get())).m_79076_(this.createEntry((ItemLike)ModItems.PROGRAMMING_PUZZLE.get(), 1, 4, 12)).m_79076_(this.createEntry((ItemLike)ModItems.MICROMISSILES.get(), 1, 1, 1)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(20));
            LootTable.Builder rareTable = LootTable.m_79147_();
            rareTable.m_79161_(rarePool);
            consumer.accept(PneumaticRegistry.RL("custom/rare_dungeon_loot"), rareTable);
        }

        private LootPoolEntryContainer.Builder<?> ammo(ItemLike item) {
            return this.createEntry(new ItemStack(item), 1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_());
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            LootPoolSingletonContainer.Builder ret = LootItem.m_79579_((ItemLike)item.m_41720_()).m_79707_(weight);
            if (item.m_41782_()) {
                ret.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)item.m_41784_()));
            }
            return ret;
        }
    }

    public static class MechanicVillagerChestLootProvider
    implements LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder lootPool = LootPool.m_79043_();
            lootPool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_79076_(this.createEntry((ItemLike)ModItems.COMPRESSED_IRON_INGOT.get(), 10, 4, 12)).m_79076_(this.createEntry((ItemLike)ModItems.AMADRON_TABLET.get(), 2, 1, 1)).m_79076_(this.createEntry((ItemLike)ModItems.AIR_CANISTER.get(), 10, 1, 5)).m_79076_(this.createEntry((ItemLike)ModItems.PNEUMATIC_CYLINDER.get(), 5, 2, 4)).m_79076_(this.createEntry((ItemLike)ModItems.LOGISTICS_CORE.get(), 8, 4, 8)).m_79076_(this.createEntry((ItemLike)ModItems.CAPACITOR.get(), 4, 4, 8)).m_79076_(this.createEntry((ItemLike)ModItems.TRANSISTOR.get(), 4, 4, 8)).m_79076_(this.createEntry((ItemLike)ModItems.TURBINE_ROTOR.get(), 5, 2, 4)).m_79076_(this.createEntry((ItemLike)ModBlocks.COMPRESSED_IRON_BLOCK.get(), 2, 1, 2)).m_79076_(this.createEntry((ItemLike)ModBlocks.VORTEX_TUBE.get(), 5, 1, 1)).m_79076_(this.createEntry((ItemLike)ModBlocks.PRESSURE_TUBE.get(), 10, 3, 8)).m_79076_(this.createEntry((ItemLike)ModBlocks.ADVANCED_PRESSURE_TUBE.get(), 4, 3, 8)).m_79076_(this.createEntry((ItemLike)ModBlocks.HEAT_PIPE.get(), 8, 3, 8)).m_79076_(this.createEntry((ItemLike)ModBlocks.APHORISM_TILE.get(), 5, 2, 3));
            LootTable.Builder lootTable = LootTable.m_79147_();
            lootTable.m_79161_(lootPool);
            consumer.accept(PneumaticRegistry.RL("chests/mechanic_house"), lootTable);
        }

        private LootPoolEntryContainer.Builder<?> createEntry(ItemLike item, int weight, int min, int max) {
            return this.createEntry(new ItemStack(item), weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        private LootPoolSingletonContainer.Builder<?> createEntry(ItemStack item, int weight) {
            LootPoolSingletonContainer.Builder ret = LootItem.m_79579_((ItemLike)item.m_41720_()).m_79707_(weight);
            if (item.m_41782_()) {
                ret.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)item.m_41784_()));
            }
            return ret;
        }
    }

    private static class BlockLootTablePNC
    extends BlockLootSubProvider {
        public BlockLootTablePNC() {
            super(Set.of(), FeatureFlags.f_244332_);
        }

        protected void m_245660_() {
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                Block b = (Block)ro.get();
                if (b instanceof PneumaticCraftEntityBlock && ForgeRegistries.ITEMS.containsKey(ro.getId())) {
                    this.addStandardSerializedDrop(b, ro.getId());
                    continue;
                }
                if (b instanceof SlabBlock) {
                    this.m_246481_(b, x$0 -> this.m_247233_((Block)x$0));
                    continue;
                }
                if (b.m_5456_() == Items.f_41852_) continue;
                this.m_245724_(b);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> l = new ArrayList<Block>();
            for (RegistryObject ro : ModBlocks.BLOCKS.getEntries()) {
                if (!ForgeRegistries.ITEMS.containsKey(ro.getId())) continue;
                l.add((Block)ro.get());
            }
            return l;
        }

        private void addStandardSerializedDrop(Block block, ResourceLocation blockId) {
            LootPool.Builder builder = LootPool.m_79043_().name(blockId.m_135815_()).m_79080_(ExplosionCondition.m_81661_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(LootFunc.BlockEntitySerializerFunction.builder()));
            this.m_247577_(block, LootTable.m_79147_().m_79161_(builder));
        }
    }
}

