/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModFluids;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModFluidTagsProvider
extends FluidTagsProvider {
    public ModFluidTagsProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, "pneumaticcraft", existingFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider pProvider) {
        this.createTag(PneumaticCraftTags.Fluids.CRUDE_OIL, new Supplier[]{ModFluids.OIL});
        this.createTag(PneumaticCraftTags.Fluids.ETCHING_ACID, new Supplier[]{ModFluids.ETCHING_ACID});
        this.createTag(PneumaticCraftTags.Fluids.PLASTIC, new Supplier[]{ModFluids.PLASTIC});
        this.createTag(PneumaticCraftTags.Fluids.LUBRICANT, new Supplier[]{ModFluids.LUBRICANT});
        this.createTag(PneumaticCraftTags.Fluids.DIESEL, new Supplier[]{ModFluids.DIESEL});
        this.createTag(PneumaticCraftTags.Fluids.KEROSENE, new Supplier[]{ModFluids.KEROSENE});
        this.createTag(PneumaticCraftTags.Fluids.GASOLINE, new Supplier[]{ModFluids.GASOLINE});
        this.createTag(PneumaticCraftTags.Fluids.LPG, new Supplier[]{ModFluids.LPG});
        this.createTag(PneumaticCraftTags.Fluids.YEAST_CULTURE, new Supplier[]{ModFluids.YEAST_CULTURE});
        this.createTag(PneumaticCraftTags.Fluids.ETHANOL, new Supplier[]{ModFluids.ETHANOL});
        this.createTag(PneumaticCraftTags.Fluids.PLANT_OIL, new Supplier[]{ModFluids.VEGETABLE_OIL});
        this.createTag(PneumaticCraftTags.Fluids.BIODIESEL, new Supplier[]{ModFluids.BIODIESEL});
        this.createTag(PneumaticCraftTags.Fluids.EXPERIENCE, new Supplier[]{ModFluids.MEMORY_ESSENCE});
        this.createAndAppend(PneumaticCraftTags.Fluids.CRUDE_OIL, PneumaticCraftTags.Fluids.SEISMIC, new Supplier[0]);
    }

    public String m_6055_() {
        return "PneumaticCraft Fluid Tags";
    }

    @SafeVarargs
    private <T> T[] resolveAll(IntFunction<T[]> creator, Supplier<? extends T> ... suppliers) {
        return Arrays.stream(suppliers).map(Supplier::get).toArray(creator);
    }

    @SafeVarargs
    private void createTag(TagKey<Fluid> tag, Supplier<? extends Fluid> ... blocks) {
        this.m_206424_(tag).m_255179_((Object[])this.resolveAll(Fluid[]::new, blocks));
    }

    @SafeVarargs
    private void appendToTag(TagKey<Fluid> tag, TagKey<Fluid> ... toAppend) {
        this.m_206424_(tag).addTags(toAppend);
    }

    @SafeVarargs
    private void createAndAppend(TagKey<Fluid> tag, TagKey<Fluid> to, Supplier<? extends Fluid> ... fluids) {
        this.createTag(tag, fluids);
        this.appendToTag(to, tag);
    }
}

