/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.worldgen;

import com.mojang.serialization.Codec;
import java.util.Collection;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModPlacementModifierTypes;
import me.desht.pneumaticcraft.common.util.WildcardedRLMatcher;
import me.desht.pneumaticcraft.mixin.accessors.WorldGenRegionAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class OilLakeFilter
extends PlacementFilter {
    private static final OilLakeFilter INSTANCE = new OilLakeFilter();
    public static final Codec<OilLakeFilter> CODEC = Codec.unit(() -> INSTANCE);

    public static OilLakeFilter oilLakeFilter() {
        return INSTANCE;
    }

    protected boolean m_213917_(PlacementContext context, RandomSource rand, BlockPos origin) {
        if (!DimensionFilter.isDimensionOK(context.m_191831_())) {
            return false;
        }
        WorldGenLevel worldGenLevel = context.m_191831_();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)worldGenLevel;
            SectionPos sectionPos = SectionPos.m_123199_((BlockPos)origin);
            ChunkAccess chunkAccess = context.m_191831_().m_46865_(origin);
            Registry reg = context.m_191831_().m_9598_().m_175515_(Registries.f_256944_);
            StructureManager sfManager = ((WorldGenRegionAccess)region).getStructureManager();
            for (Holder structureHolder : reg.m_203561_(PneumaticCraftTags.Structures.NO_OIL_LAKES)) {
                StructureStart startForFeature = sfManager.m_220512_(sectionPos, (Structure)structureHolder.m_203334_(), (StructureAccess)chunkAccess);
                if (startForFeature == null || !startForFeature.m_73603_()) continue;
                return false;
            }
        }
        return true;
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)ModPlacementModifierTypes.OIL_LAKE_FILTER.get();
    }

    public static class DimensionFilter {
        private static WildcardedRLMatcher dimensionMatcherB = null;
        private static WildcardedRLMatcher dimensionMatcherW = null;

        private static boolean isDimensionOK(WorldGenLevel level) {
            ResourceLocation name = level.m_6018_().m_46472_().m_135782_();
            return DimensionFilter.getDimensionWhitelist().isEmpty() ? !DimensionFilter.getDimensionBlacklist().test(name) : DimensionFilter.getDimensionWhitelist().test(name);
        }

        private static WildcardedRLMatcher getDimensionWhitelist() {
            if (dimensionMatcherW == null) {
                dimensionMatcherW = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenDimensionWhitelist.get());
            }
            return dimensionMatcherW;
        }

        private static WildcardedRLMatcher getDimensionBlacklist() {
            if (dimensionMatcherB == null) {
                dimensionMatcherB = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenDimensionBlacklist.get());
            }
            return dimensionMatcherB;
        }

        public static void clearMatcherCaches() {
            dimensionMatcherB = null;
            dimensionMatcherW = null;
        }
    }
}

