/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class UpgradeCache {
    private byte[] countCache;
    private final IUpgradeHolder holder;
    private Direction ejectDirection;

    public UpgradeCache(IUpgradeHolder holder) {
        this.holder = holder;
    }

    public void invalidateCache() {
        this.countCache = null;
    }

    public int getUpgrades(PNCUpgrade type) {
        this.validateCache();
        return this.countCache[type.getCacheId()];
    }

    public Direction getEjectDirection() {
        return this.ejectDirection;
    }

    public void validateCache() {
        if (this.countCache != null) {
            return;
        }
        this.countCache = new byte[this.largestID() + 1];
        IItemHandler handler = this.holder.getUpgradeHandler();
        this.ejectDirection = null;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (item instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item;
                PNCUpgrade upgradeType = upgradeItem.getUpgradeType();
                if (this.countCache[upgradeType.getCacheId()] != 0) {
                    Log.warning("found upgrade " + upgradeType + " in multiple slots! Ignoring.", new Object[0]);
                    continue;
                }
                this.countCache[upgradeType.getCacheId()] = (byte)(stack.m_41613_() * upgradeItem.getUpgradeTier());
                this.handleExtraData(stack, upgradeType);
                continue;
            }
            if (stack.m_41619_()) continue;
            throw new IllegalStateException("found non-upgrade item in an upgrade handler! " + stack);
        }
        this.holder.onUpgradesChanged();
    }

    public CompoundTag toNBT() {
        IItemHandler handler = this.holder.getUpgradeHandler();
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof IUpgradeItem)) continue;
            IUpgradeItem upgradeItem = (IUpgradeItem)item;
            String key = PneumaticCraftUtils.modDefaultedString(upgradeItem.getUpgradeType().getId());
            int count = upgradeItem.getUpgradeTier() * stack.m_41613_();
            tag.m_128365_(key, (Tag)IntTag.m_128679_((int)count));
        }
        return tag;
    }

    private int largestID() {
        int max = 0;
        for (PNCUpgrade upgrade : PneumaticRegistry.getInstance().getUpgradeRegistry().getKnownUpgrades()) {
            max = Math.max(max, upgrade.getCacheId());
        }
        return max;
    }

    private void handleExtraData(ItemStack stack, PNCUpgrade type) {
        if (type == ModUpgrades.DISPENSER.get() && stack.m_41782_()) {
            this.ejectDirection = Direction.m_122402_((String)NBTUtils.getString(stack, "Facing"));
        }
    }
}

