/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneEmittingModule;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PressureGaugeModule
extends AbstractRedstoneEmittingModule {
    private boolean hideGauge = false;

    public PressureGaugeModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
        this.lowerBound = 0.0f;
        this.higherBound = 7.5f;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.PRESSURE_GAUGE_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.pressureTube.nonNullLevel().m_46467_() % 20L == 0L) {
            this.pressureTube.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> NetworkHandler.sendToAllTracking((Object)new PacketUpdatePressureBlock(this.pressureTube, null, h.getSideLeaking(), h.getAir()), this.pressureTube));
        }
        if (this.setRedstone(this.getRedstone(this.pressureTube.getPressure()))) {
            this.pressureTube.tubeModules().filter(tm -> tm instanceof RedstoneModule).forEach(tm -> ((RedstoneModule)tm).setInputLevel(-1));
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (ModdedWrenchUtils.getInstance().isWrench(heldStack)) {
            this.hideGauge = !this.hideGauge;
            this.setChanged();
            this.getTube().sendDescriptionPacket();
            return true;
        }
        return super.onActivated(player, hand);
    }

    public boolean shouldShowGauge() {
        return !this.hideGauge;
    }

    private int getRedstone(float pressure) {
        return (int)((pressure - this.lowerBound) / (this.higherBound - this.lowerBound) * 15.0f);
    }

    @Override
    public double getWidth() {
        return 8.0;
    }

    @Override
    protected double getHeight() {
        return 4.0;
    }

    @Override
    public boolean hasGui() {
        return this.upgraded;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.hideGauge) {
            tag.m_128379_("hideGauge", true);
        }
        return tag;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.hideGauge = tag.m_128471_("hideGauge");
    }
}

