/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public enum SemiblockTracker {
    INSTANCE;

    private static final Map<ResourceLocation, Map<BlockPos, SemiblockCollection>> semiblockMap;

    public static SemiblockTracker getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        if (!event.getServer().m_6982_()) {
            semiblockMap.values().forEach(Map::clear);
            semiblockMap.clear();
        }
    }

    public ISemiBlock getSemiblock(Level world, BlockPos pos) {
        return this.getSemiblock(world, pos, null);
    }

    public ISemiBlock getSemiblock(Level world, BlockPos pos, Direction direction) {
        if (!world.m_46749_(pos)) {
            return null;
        }
        Map<BlockPos, SemiblockCollection> map = semiblockMap.get(this.getKey(world));
        if (map == null) {
            return null;
        }
        SemiblockCollection sc = map.get(pos);
        return sc == null ? null : sc.get(direction);
    }

    public Stream<ISemiBlock> getAllSemiblocks(Level world, BlockPos pos) {
        return this.getAllSemiblocks(world, pos, null);
    }

    public Stream<ISemiBlock> getAllSemiblocks(Level world, BlockPos pos, Direction offsetDir) {
        if (!world.m_46749_(pos)) {
            return Stream.empty();
        }
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        if (map.isEmpty()) {
            return Stream.empty();
        }
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null && offsetDir != null) {
            sc = (SemiblockCollection)map.get(pos.m_121945_(offsetDir));
        }
        return sc == null ? Stream.empty() : sc.getAll();
    }

    public void clearSemiblock(Level world, BlockPos pos, Direction direction) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc != null) {
            sc.clear(direction);
        }
    }

    public boolean putSemiblock(Level world, BlockPos pos, ISemiBlock entity) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        SemiblockCollection sc = (SemiblockCollection)map.get(pos);
        if (sc == null) {
            map.put(pos, new SemiblockCollection(entity));
            return true;
        }
        return sc.set(entity);
    }

    public Stream<ISemiBlock> getSemiblocksInArea(Level world, AABB aabb) {
        Map map = semiblockMap.computeIfAbsent(this.getKey(world), k -> new HashMap());
        return map.entrySet().stream().filter(e -> this.aabbContainsBlockPos(aabb, (BlockPos)e.getKey())).flatMap(e -> ((SemiblockCollection)e.getValue()).getAll());
    }

    private boolean aabbContainsBlockPos(AABB aabb, BlockPos pos) {
        return (double)pos.m_123341_() >= aabb.f_82288_ && (double)pos.m_123341_() <= aabb.f_82291_ && (double)pos.m_123342_() >= aabb.f_82289_ && (double)pos.m_123342_() <= aabb.f_82292_ && (double)pos.m_123343_() >= aabb.f_82290_ && (double)pos.m_123343_() <= aabb.f_82293_;
    }

    private ResourceLocation getKey(Level world) {
        return world.m_46472_().m_135782_();
    }

    static {
        semiblockMap = new HashMap<ResourceLocation, Map<BlockPos, SemiblockCollection>>();
    }

    private static class SemiblockCollection {
        private WeakReference<ISemiBlock> center = new WeakReference<Object>(null);
        private final List<WeakReference<ISemiBlock>> sides = new ArrayList<WeakReference<ISemiBlock>>();

        SemiblockCollection(ISemiBlock e) {
            this.set(e);
        }

        public ISemiBlock get(Direction direction) {
            if (direction == null) {
                return (ISemiBlock)this.center.get();
            }
            return this.sides.isEmpty() ? null : (ISemiBlock)this.sides.get(direction.m_122411_()).get();
        }

        boolean set(ISemiBlock semiBlock) {
            Direction dir;
            Direction direction = dir = semiBlock instanceof IDirectionalSemiblock ? ((IDirectionalSemiblock)((Object)semiBlock)).getSide() : null;
            if (dir == null) {
                if (this.center.get() != null) {
                    return false;
                }
                this.center = new WeakReference<ISemiBlock>(semiBlock);
            } else {
                if (this.sides.isEmpty()) {
                    for (int i = 0; i < 6; ++i) {
                        this.sides.add(new WeakReference<Object>(null));
                    }
                }
                if (this.sides.get(dir.m_122411_()).get() != null) {
                    return false;
                }
                this.sides.set(dir.m_122411_(), new WeakReference<ISemiBlock>(semiBlock));
            }
            return true;
        }

        public void clear(Direction direction) {
            if (direction == null) {
                if (this.center != null) {
                    this.center.clear();
                }
            } else if (!this.sides.isEmpty()) {
                this.sides.get(direction.m_122411_()).clear();
            }
        }

        Stream<ISemiBlock> getAll() {
            Stream s1 = this.center.get() == null ? Stream.empty() : Stream.of((ISemiBlock)this.center.get());
            Stream<ISemiBlock> s2 = this.sides.stream().filter(ref -> ref.get() != null).map(Reference::get);
            return Stream.concat(s1, s2);
        }
    }
}

