/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import java.util.Arrays;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.item.DroneItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class DroneColorCrafting
extends ShapelessRecipe {
    private static final Item[] DYES = new Item[DyeColor.values().length];

    public DroneColorCrafting(ResourceLocation idIn, CraftingBookCategory category) {
        super(idIn, "", category, new ItemStack((ItemLike)ModItems.DRONE.get()), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])DYES), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DRONE.get()})}));
    }

    private Pair<ItemStack, DyeColor> findItems(CraftingContainer inv) {
        ItemStack drone = ItemStack.f_41583_;
        DyeColor dye = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() instanceof DroneItem) {
                if (!drone.m_41619_()) {
                    return null;
                }
                drone = stack.m_41777_();
            } else if (dye == null) {
                DyeColor color = DyeColor.getColor((ItemStack)stack);
                if (color != null) {
                    dye = color;
                }
            } else if (!stack.m_41619_()) {
                return null;
            }
            if (!drone.m_41619_() && dye != null) break;
        }
        return drone.m_41619_() || dye == null ? null : Pair.of((Object)drone, dye);
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return this.findItems(inv) != null;
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        Pair<ItemStack, DyeColor> data = this.findItems(inv);
        if (data == null) {
            return ItemStack.f_41583_;
        }
        ItemStack drone = (ItemStack)data.getLeft();
        DyeColor dyeColor = (DyeColor)data.getRight();
        if (drone.m_41619_() || dyeColor == null) {
            return ItemStack.f_41583_;
        }
        CompoundTag droneTag = drone.m_41784_();
        droneTag.m_128405_("color", dyeColor.m_41060_());
        return drone;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.DRONE_COLOR_CRAFTING.get();
    }

    static {
        Arrays.setAll(DYES, i -> DyeItem.m_41082_((DyeColor)DyeColor.values()[i]));
    }
}

