/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor.handlers;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.BaseArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ChargingHandler
extends BaseArmorUpgradeHandler<IArmorExtensionData> {
    @Override
    public ResourceLocation getID() {
        return BuiltinArmorUpgrades.CHARGING;
    }

    @Override
    public PNCUpgrade[] getRequiredUpgrades() {
        return new PNCUpgrade[]{ModUpgrades.CHARGING.get()};
    }

    @Override
    public int getMaxInstallableUpgrades(PNCUpgrade upgrade) {
        return 6;
    }

    @Override
    public float getIdleAirUsage(ICommonArmorHandler armorHandler) {
        return 0.0f;
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    @Override
    public void tick(ICommonArmorHandler commonArmorHandler, boolean enabled) {
        Player player = commonArmorHandler.getPlayer();
        if (player.m_9236_().f_46443_ || !enabled || player.m_9236_().m_46467_() % 20L != 5L) {
            return;
        }
        int upgrades = commonArmorHandler.getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.CHARGING.get());
        int airAmount = upgrades * 100 + 100;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot == EquipmentSlot.CHEST) continue;
            if (!commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST)) {
                return;
            }
            this.tryPressurize(commonArmorHandler, airAmount, player.m_6844_(slot));
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!commonArmorHandler.hasMinPressure(EquipmentSlot.CHEST)) {
                return;
            }
            this.tryPressurize(commonArmorHandler, airAmount, stack);
        }
    }

    private void tryPressurize(ICommonArmorHandler commonArmorHandler, int airAmount, ItemStack destStack) {
        if (destStack.m_41613_() == 1) {
            destStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(destHandler -> {
                float pressure = destHandler.getPressure();
                if (pressure < destHandler.maxPressure() && pressure < commonArmorHandler.getArmorPressure(EquipmentSlot.CHEST)) {
                    int currentAir = destHandler.getAir();
                    int targetAir = (int)(commonArmorHandler.getArmorPressure(EquipmentSlot.CHEST) * (float)destHandler.getVolume());
                    int amountToMove = Mth.m_14045_((int)(targetAir - currentAir), (int)(-airAmount), (int)airAmount);
                    destHandler.addAir(amountToMove);
                    commonArmorHandler.addAir(EquipmentSlot.CHEST, -amountToMove);
                }
            });
        }
    }
}

