/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeBox
extends AreaType {
    public static final String ID = "box";
    private EnumBoxType boxType = EnumBoxType.FILLED;

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.boxType) {
            case FILLED: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = maxY; y >= minY; --y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case FRAME: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            int axisRight = 0;
                            if (x == minX || x == maxX) {
                                ++axisRight;
                            }
                            if (y == minY || y == maxY) {
                                ++axisRight;
                            }
                            if (z == minZ || z == maxZ) {
                                ++axisRight;
                            }
                            if (axisRight <= 1) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case HOLLOW: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.boxType.toString());
            }
        }
    }

    public AreaTypeBox() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.boxType;
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case FILL: {
                this.boxType = EnumBoxType.FILLED;
                break;
            }
            case WALL: {
                this.boxType = EnumBoxType.HOLLOW;
                break;
            }
            case FRAME: {
                this.boxType = EnumBoxType.FRAME;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumBoxType>("pneumaticcraft.gui.progWidget.area.type.box.boxType", EnumBoxType.class, () -> this.boxType, boxType -> {
            this.boxType = boxType;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("boxType", (byte)this.boxType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.boxType = EnumBoxType.values()[tag.m_128445_("boxType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.boxType.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.boxType = EnumBoxType.values()[buf.readByte()];
    }

    private static enum EnumBoxType implements ITranslatableEnum
    {
        FILLED("filled"),
        HOLLOW("hollow"),
        FRAME("frame");

        private final String name;

        private EnumBoxType(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.box.boxType." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

