/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ProgWidget
implements IProgWidget {
    static final MutableComponent ALL_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.all", new Object[0]);
    static final MutableComponent NONE_TEXT = PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]);
    private final ProgWidgetType<?> type;
    private int x;
    private int y;
    private IProgWidget[] connectedParameters;
    private IProgWidget outputStepConnection;
    private IProgWidget parent;
    private Pair<Float, Float> maxUV = null;

    public ProgWidget(ProgWidgetType<?> type) {
        this.type = type;
        if (!this.getParameters().isEmpty()) {
            this.connectedParameters = new IProgWidget[this.getParameters().size() * 2];
        }
    }

    @Override
    public ProgWidgetType<?> getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getTypeID() {
        return ModProgWidgets.PROG_WIDGETS.get().getKey(this.getType());
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        curTooltip.add((Component)PneumaticCraftUtils.xlate(this.getTranslationKey(), new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.UNDERLINE}));
        if (this.freeToUse()) {
            curTooltip.add((Component)Component.m_237115_((String)"pneumaticcraft.gui.progWidget.comment.tooltip.freeToUse"));
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.emptyList();
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        if (this instanceof IVariableWidget) {
            HashSet<String> variables = new HashSet<String>();
            ((IVariableWidget)((Object)this)).addVariables(variables);
            for (String variable : variables) {
                if (variable.isEmpty() || variable.startsWith("#") || variable.startsWith("$") || this.isVariableSetAnywhere(widgets, variable)) continue;
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.warning.variableNeverSet", variable));
            }
        }
    }

    private boolean isVariableSetAnywhere(List<IProgWidget> widgets, String variable) {
        if (variable.isEmpty()) {
            return true;
        }
        for (IProgWidget widget : widgets) {
            if (!(widget instanceof IVariableSetWidget)) continue;
            HashSet<String> variables = new HashSet<String>();
            ((IVariableSetWidget)((Object)widget)).addVariables(variables);
            if (!variables.contains(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        if (!this.hasStepInput() && this.hasStepOutput() && this.outputStepConnection == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noPieceConnected", new Object[0]));
        }
    }

    @Override
    public boolean isAvailable() {
        return !ProgWidgetConfig.INSTANCE.isWidgetBlacklisted(this.getType());
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return 30;
    }

    @Override
    public int getHeight() {
        return !this.getParameters().isEmpty() ? this.getParameters().size() * 22 : 22;
    }

    @Override
    public void setParent(IProgWidget widget) {
        this.parent = widget;
    }

    @Override
    public IProgWidget getParent() {
        return this.parent;
    }

    @Override
    public Pair<Float, Float> getMaxUV() {
        if (this.maxUV == null) {
            int textureSize;
            int width = this.getWidth() + (this.getParameters().isEmpty() ? 0 : 10);
            int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
            int maxSize = Math.max(width, height);
            for (textureSize = 1; textureSize < maxSize; textureSize *= 2) {
            }
            float u = (float)width / (float)textureSize;
            float v = (float)height / (float)textureSize;
            this.maxUV = new ImmutablePair((Object)Float.valueOf(u), (Object)Float.valueOf(v));
        }
        return this.maxUV;
    }

    @Override
    public boolean hasStepOutput() {
        return this.hasStepInput();
    }

    @Override
    public Goal getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public void setParameter(int index, IProgWidget parm) {
        int index2;
        int n = index2 = index >= this.getParameters().size() ? index - this.getParameters().size() : index;
        if (this.connectedParameters != null && (parm == null || parm.getType() == this.getParameters().get(index2))) {
            this.connectedParameters[index] = parm;
        }
    }

    @Override
    public boolean canSetParameter(int index) {
        if (this.connectedParameters != null) {
            return this.hasBlacklist() || index < this.connectedParameters.length / 2;
        }
        return false;
    }

    protected boolean hasBlacklist() {
        return true;
    }

    @Override
    public IProgWidget[] getConnectedParameters() {
        return this.connectedParameters;
    }

    @Override
    public void setOutputWidget(IProgWidget widget) {
        this.outputStepConnection = widget;
    }

    @Override
    public IProgWidget getOutputWidget() {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget copy() {
        IProgWidget copy = IProgWidget.create(this.getType());
        CompoundTag tag = new CompoundTag();
        this.writeToNBT(tag);
        copy.readFromNBT(tag);
        return copy;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128359_("name", PneumaticCraftUtils.modDefaultedString(this.getTypeID()));
        tag.m_128405_("x", this.x);
        tag.m_128405_("y", this.y);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.x = tag.m_128451_("x");
        this.y = tag.m_128451_("y");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        buf.m_130070_(PneumaticCraftUtils.modDefaultedString(this.getTypeID()));
        buf.writeInt(this.x);
        buf.writeInt(this.y);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
    }

    static <T extends IProgWidget> List<T> getConnectedWidgetList(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        ProgWidget.validateType(widget, parameterIndex, type);
        IProgWidget connectingWidget = widget.getConnectedParameters()[parameterIndex];
        if (connectingWidget != null) {
            ArrayList<IProgWidget> list = new ArrayList<IProgWidget>();
            while (connectingWidget != null) {
                list.add((IProgWidget)type.cast(connectingWidget));
                connectingWidget = connectingWidget.getConnectedParameters()[0];
            }
            return list;
        }
        return null;
    }

    private static <T extends IProgWidget> void validateType(IProgWidget widget, int parameterIndex, ProgWidgetType<T> type) {
        int l = widget.getParameters().size();
        if (parameterIndex >= l) {
            parameterIndex -= l;
        }
        if (type != widget.getParameters().get(parameterIndex)) {
            throw new IllegalArgumentException(String.format("invalid type %s for parameter %d (expected %s)", type, parameterIndex, widget.getParameters().get(parameterIndex)));
        }
    }

    public static IProgWidget fromPacket(FriendlyByteBuf buf) {
        ResourceLocation typeID = PneumaticCraftUtils.modDefaultedRL(buf.m_130136_(256));
        ProgWidgetType type = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(typeID);
        if (type != null) {
            IProgWidget newWidget = IProgWidget.create(type);
            newWidget.readFromPacket(buf);
            return newWidget;
        }
        throw new IllegalStateException("can't read progwidget from packet: bad widget ID: " + typeID);
    }

    public static IProgWidget fromNBT(CompoundTag widgetTag) {
        ResourceLocation typeID = PneumaticCraftUtils.modDefaultedRL(widgetTag.m_128461_("name"));
        ProgWidgetType type = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS.get().getValue(typeID);
        if (type == null) {
            Log.warning("can't read progwidget from NBT: bad widget ID: " + typeID, new Object[0]);
            return null;
        }
        IProgWidget widget = IProgWidget.create(type);
        widget.readFromNBT(widgetTag);
        return widget;
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return this.getWidgetAI(drone, widget) != null;
    }

    Component varAsTextComponent(String var) {
        return var.isEmpty() ? Component.m_237119_() : Component.m_237113_((String)("\"" + var + "\""));
    }
}

