/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorItem;
import me.desht.pneumaticcraft.common.item.CreativeTabStackProvider;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.recipes.special.PatchouliBookCrafting;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModCreativeModeTab {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"pneumaticcraft");
    public static final RegistryObject<CreativeModeTab> DEFAULT = TABS.register("default", ModCreativeModeTab::buildDefaultTab);

    private static CreativeModeTab buildDefaultTab() {
        List items = ModItems.ITEMS.getEntries().stream().flatMap(ro -> ModCreativeModeTab.stacksForItem((Item)ro.get())).sorted(new ItemSorter()).collect(Collectors.toCollection(ArrayList::new));
        if (ModList.get().isLoaded("patchouli")) {
            items.add(PatchouliBookCrafting.makeGuideBook());
        }
        return CreativeModeTab.builder().m_257941_((Component)PneumaticCraftUtils.xlate("itemGroup.pneumaticcraft", new Object[0])).m_257737_(() -> new ItemStack((ItemLike)ModItems.PRESSURE_GAUGE.get())).m_257501_((params, output) -> output.m_246601_((Collection)items)).m_257652_();
    }

    private static Stream<ItemStack> stacksForItem(Item item) {
        BlockItem bi;
        Block block;
        ItemStack stack = new ItemStack((ItemLike)item);
        if (item instanceof CreativeTabStackProvider) {
            CreativeTabStackProvider provider = (CreativeTabStackProvider)item;
            return provider.getStacksForItem();
        }
        if (item instanceof BlockItem && (block = (bi = (BlockItem)item).m_40614_()) instanceof CreativeTabStackProvider) {
            CreativeTabStackProvider provider = (CreativeTabStackProvider)block;
            return provider.getStacksForItem();
        }
        if (item instanceof IPressurizableItem) {
            IPressurizableItem p = (IPressurizableItem)item;
            ItemStack stack2 = stack.m_41777_();
            new AirHandlerItemStack(stack2).addAir((int)((float)p.getBaseVolume() * p.getMaxPressure()));
            return Stream.of(new ItemStack((ItemLike)item), stack2);
        }
        return Stream.of(stack);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private ItemSorter() {
        }

        @Override
        public int compare(ItemStack s1, ItemStack s2) {
            for (Class<PneumaticCraftBucketItem> cls : List.of(BlockItem.class, PressurizableItem.class, CompressedIronArmorItem.class, PneumaticArmorItem.class, SemiblockItem.class, AbstractGunAmmoItem.class, UpgradeItem.class, TubeModuleItem.class, PneumaticCraftBucketItem.class)) {
                if (cls.isAssignableFrom(s1.m_41720_().getClass()) && !cls.isAssignableFrom(s2.m_41720_().getClass())) {
                    return -1;
                }
                if (!cls.isAssignableFrom(s2.m_41720_().getClass()) || cls.isAssignableFrom(s1.m_41720_().getClass())) continue;
                return 1;
            }
            return s1.m_41611_().getString().compareTo(s2.m_41611_().getString());
        }
    }
}

