/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.EnumMap;
import java.util.Map;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class DroneRedstoneEmitterBlockEntity
extends AbstractTickingBlockEntity {
    private IDroneBase owner;
    private final Map<Direction, Integer> signalLevels = new EnumMap<Direction, Integer>(Direction.class);

    public DroneRedstoneEmitterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.DRONE_REDSTONE_EMITTER.get()), pos, state);
    }

    public void setOwner(IDroneBase owner) {
        this.owner = owner;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void tickServer() {
        if (this.owner == null || !this.owner.isDroneStillValid()) {
            this.nonNullLevel().m_7471_(this.m_58899_(), false);
        } else {
            boolean changed = false;
            this.signalLevels.clear();
            for (Direction facing : DirectionUtil.VALUES) {
                int signal = this.owner.getEmittingRedstone(facing);
                if (signal != this.signalLevels.getOrDefault(facing, 0)) {
                    changed = true;
                }
                if (signal <= 0) continue;
                this.signalLevels.put(facing, signal);
            }
            if (this.signalLevels.isEmpty()) {
                this.nonNullLevel().m_7471_(this.m_58899_(), false);
            } else if (changed) {
                this.updateNeighbours();
            }
        }
    }

    public int getSignalLevel(Direction side) {
        return this.owner == null || !this.owner.isDroneStillValid() ? 0 : this.signalLevels.getOrDefault(side.m_122424_(), 0);
    }
}

