/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PneumaticDoorBaseBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)16.0, (double)14.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public PneumaticDoorBaseBlock() {
        super(ModBlocks.defaultProps().m_60955_());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return SHAPES[d.m_122416_()];
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        world.m_141902_(pos, (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR_BASE.get()).ifPresent(this::updateDoorSide);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        world.m_141902_(pos, (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR_BASE.get()).ifPresent(teDoorBase -> {
            this.updateDoorSide((PneumaticDoorBaseBlockEntity)teDoorBase);
            teDoorBase.onNeighborBlockUpdate(fromPos);
            BlockPos doorPos = pos.m_121945_(teDoorBase.getRotation());
            BlockState doorState = world.m_8055_(doorPos);
            if (doorState.m_60734_() instanceof PneumaticDoorBlock) {
                doorState.m_60690_(world, doorPos, doorState.m_60734_(), pos, false);
            }
        });
    }

    private void updateDoorSide(PneumaticDoorBaseBlockEntity doorBase) {
        doorBase.nonNullLevel().m_141902_(doorBase.m_58899_().m_121945_(doorBase.getRotation()), (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR.get()).ifPresent(teDoor -> {
            if (doorBase.getRotation().m_122427_() == teDoor.getRotation() && teDoor.rightGoing || doorBase.getRotation().m_122428_() == teDoor.getRotation() && !teDoor.rightGoing) {
                teDoor.rightGoing = !teDoor.rightGoing;
                teDoor.setRotationAngle(0.0f);
                teDoor.m_6596_();
            }
        });
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.m_141902_(pos, (BlockEntityType)ModBlockEntities.PNEUMATIC_DOOR_BASE.get()).map(te -> te.shouldPassSignalToDoor() && side == te.getRotation().m_122424_() ? te.getCurrentRedstonePower() : 0).orElse(0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PneumaticDoorBaseBlockEntity(pPos, pState);
    }
}

