/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.SentryTurretBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class MovingSoundMinigun
extends AbstractTickableSoundInstance {
    private final Entity entity;
    private final BlockEntity tileEntity;
    private boolean finished = false;

    MovingSoundMinigun(Entity entity) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundSource.NEUTRAL, SoundInstance.m_235150_());
        this.entity = entity;
        this.tileEntity = null;
        this.init(entity instanceof DroneEntity ? ((Double)ConfigHelper.client().sound.minigunVolumeDrone.get()).floatValue() : ((Double)ConfigHelper.client().sound.minigunVolumeHeld.get()).floatValue());
    }

    MovingSoundMinigun(BlockEntity te) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundSource.NEUTRAL, SoundInstance.m_235150_());
        this.entity = null;
        this.tileEntity = te;
        this.f_119575_ = this.tileEntity.m_58899_().m_123341_();
        this.f_119576_ = this.tileEntity.m_58899_().m_123342_();
        this.f_119577_ = this.tileEntity.m_58899_().m_123343_();
        this.init(((Double)ConfigHelper.client().sound.minigunVolumeSentryTurret.get()).floatValue());
    }

    private void init(float volume) {
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = volume;
    }

    public void m_7788_() {
        Minigun minigun = null;
        boolean wasFinished = this.finished;
        if (this.entity != null) {
            if (!this.entity.m_6084_()) {
                this.finished = true;
            } else {
                this.f_119575_ = (float)this.entity.m_20185_();
                this.f_119576_ = (float)this.entity.m_20186_();
                this.f_119577_ = (float)this.entity.m_20189_();
                Entity entity = this.entity;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemStack curItem = player.m_21205_();
                    if (curItem.m_41720_() == ModItems.MINIGUN.get()) {
                        minigun = ((MinigunItem)ModItems.MINIGUN.get()).getMinigun(curItem, player);
                    }
                } else {
                    entity = this.entity;
                    if (entity instanceof DroneEntity) {
                        DroneEntity drone = (DroneEntity)entity;
                        minigun = drone.getMinigun();
                    }
                }
            }
        } else if (this.tileEntity != null) {
            if (this.tileEntity.m_58901_()) {
                this.finished = true;
            } else if (this.tileEntity instanceof SentryTurretBlockEntity) {
                minigun = ((SentryTurretBlockEntity)this.tileEntity).getMinigun();
            }
        }
        if (minigun != null) {
            this.playParticles(minigun);
        }
        boolean bl = this.finished = minigun == null || !minigun.isMinigunActivated() || (double)minigun.getMinigunSpeed() < 0.36000000536441806;
        if (this.finished && !wasFinished) {
            Vec3 startVec;
            ClientUtils.getClientLevel().m_6263_(ClientUtils.getClientPlayer(), this.f_119575_, this.f_119576_, this.f_119577_, (SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.NEUTRAL, this.f_119573_, 1.0f);
            if (minigun != null && (startVec = minigun.getMuzzlePosition()) != null) {
                ClientUtils.getClientLevel().m_7106_((ParticleOptions)ParticleTypes.f_123755_, startVec.f_82479_, startVec.f_82480_, startVec.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    private void playParticles(Minigun minigun) {
        Vec3 muzzlePos = minigun.getMuzzlePosition();
        if (muzzlePos == null) {
            return;
        }
        Vec3 lookVec = minigun.getLookAngle();
        RandomSource r = ClientUtils.getClientLevel().f_46441_;
        for (int i = 0; i < 10; ++i) {
            Vec3 velVec = lookVec.m_82490_((double)(3.0f + (float)i * 0.2f));
            Particle bullet = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticleTypes.BULLET_PARTICLE.get(), muzzlePos.f_82479_ + (double)(r.m_188501_() * 0.1f) - (double)0.05f, muzzlePos.f_82480_ + (double)(r.m_188501_() * 0.1f) - (double)0.05f, muzzlePos.f_82481_ + (double)(r.m_188501_() * 0.1f) - (double)0.05f, velVec.f_82479_, velVec.f_82480_, velVec.f_82481_);
            if (bullet == null) continue;
            switch (r.m_188503_(8)) {
                case 0: {
                    bullet.m_107253_(0.1f, 0.1f, 0.1f);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    bullet.m_107253_(1.0f, 0.25f + r.m_188501_() * 0.75f, 0.0f);
                    break;
                }
                default: {
                    float[] rgb = RenderUtils.decomposeColorF(minigun.getAmmoColor());
                    bullet.m_107253_(rgb[1], rgb[2], rgb[3]);
                }
            }
            bullet.m_6569_(minigun.getParticleScale());
        }
        if (r.m_188503_(10) == 0) {
            ClientUtils.getClientLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, muzzlePos.f_82479_, muzzlePos.f_82480_, muzzlePos.f_82481_, lookVec.f_82479_ * (double)0.01f, lookVec.f_82480_ * (double)0.01f, lookVec.f_82481_ * (double)0.01f);
        }
    }

    public boolean m_7801_() {
        return this.finished;
    }
}

