/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;

public abstract class PressureChamberRecipe
extends PneumaticCraftRecipe {
    protected PressureChamberRecipe(ResourceLocation id) {
        super(id);
    }

    public abstract float getCraftingPressure(IItemHandler var1, IntList var2);

    public abstract float getCraftingPressureForDisplay();

    public abstract IntCollection findIngredients(@Nonnull IItemHandler var1);

    public abstract List<Ingredient> getInputsForDisplay();

    protected List<ItemStack> getSingleResultsForDisplay() {
        return ImmutableList.of();
    }

    public List<List<ItemStack>> getResultsForDisplay() {
        return (List)this.getSingleResultsForDisplay().stream().map(ImmutableList::of).collect(ImmutableList.toImmutableList());
    }

    protected List<Set<RecipeSlot>> getSyncGroupsForDisplay() {
        return ImmutableList.of();
    }

    public Map<RecipeSlot, IntList> getSyncForDisplay(SlotCycle focusedSlotCycle) {
        RecipeSlot focusedSlot = focusedSlotCycle.slot();
        return (Map)this.getSyncGroupsForDisplay().stream().filter(set -> set.contains(focusedSlot)).findAny().map(set -> (ImmutableMap)set.stream().collect(ImmutableMap.toImmutableMap(slot -> slot, slot -> focusedSlotCycle.cycle()))).orElseGet(ImmutableMap::of);
    }

    public abstract boolean isValidInputItem(ItemStack var1);

    @Nonnull
    public abstract NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler var1, IntList var2, boolean var3);

    public String getTooltipKey(boolean input, String slotName) {
        return "";
    }

    public record SlotCycle(RecipeSlot slot, IntList cycle) {
    }

    public record RecipeSlot(boolean input, int index) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeSlot that = (RecipeSlot)o;
            return this.input == that.input && this.index == that.index;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.input, this.index);
        }
    }
}

