/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketRotateTile
extends PacketBase {
    private BlockPos pos;

    public PacketRotateTile() {
    }

    public PacketRotateTile(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public PacketBase read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        return new PacketRotateTile(this.pos);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    public Optional<NetworkDirection> getNetworkDirection() {
        return Optional.of(NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    protected void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockEntity te;
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        ServerLevel world = player.m_284548_();
        double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) + 2.0;
        if (player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) < reach * reach && (te = world.m_7702_(this.pos)) instanceof TilePlacedItems) {
            ((TilePlacedItems)te).rotateTile();
        }
    }
}

