/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.joml.Vector2i;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class Util {
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final Level[] lastLevel = new Level[2];
    private static final ChunkAccess[] lastChunk = new ChunkAccess[2];
    private static final long[] lastChunkPos = new long[2];
    private static final Long2ObjectOpenHashMap<BlockState> endOfTickStates = new Long2ObjectOpenHashMap(4096, 0.75f);
    private static final BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos();
    private static final ObjectArrayList<Long2ObjectLinkedOpenHashMap<BlockState>> existingMaps = new ObjectArrayList();
    private static final Long2ObjectLinkedOpenHashMap<Long2ObjectLinkedOpenHashMap<BlockState>> stateChunks = new Long2ObjectLinkedOpenHashMap();
    private static final ObjectArrayList<boolean[]> existingArrays = new ObjectArrayList();
    private static final Long2ObjectLinkedOpenHashMap<boolean[]> updateArrays = new Long2ObjectLinkedOpenHashMap();
    private static final TagKey<Item> WRENCH_TAG_0 = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)new ResourceLocation("forge:tools/wrench"));
    private static final TagKey<Item> WRENCH_TAG_1 = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)new ResourceLocation("forge:wrenches"));

    public static void setBlockState(Level level, BlockPos pos, BlockState state) {
        int arrayIndex = level.f_46443_ ? 1 : 0;
        long chunkPos = ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
        if (lastLevel[arrayIndex] != level || chunkPos != lastChunkPos[arrayIndex]) {
            Util.lastLevel[arrayIndex] = level;
            Util.lastChunkPos[arrayIndex] = chunkPos;
            Util.lastChunk[arrayIndex] = level.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        }
        lastChunk[arrayIndex].m_6978_(pos, state, false);
    }

    @Contract(pure=true)
    public static BlockEntity getTile(Level level, BlockPos pos) {
        int arrayIndex = level.f_46443_ ? 1 : 0;
        long chunkPos = ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
        if (lastLevel[arrayIndex] != level || chunkPos != lastChunkPos[arrayIndex] || lastChunk[arrayIndex] == null) {
            Util.lastLevel[arrayIndex] = level;
            Util.lastChunkPos[arrayIndex] = chunkPos;
            Util.lastChunk[arrayIndex] = level.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
        }
        if (lastChunk[arrayIndex] == null) {
            return null;
        }
        return lastChunk[arrayIndex].m_7702_(pos);
    }

    public static String readResourceLocation(ResourceLocation location) {
        String string;
        block9: {
            BufferedReader reader = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).orElseThrow()).m_215508_();
            try {
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append("\n");
                }
                string = stringBuilder.toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    public static JsonObject readJSONFile(ResourceLocation location) {
        String jsonString;
        if (location.m_135815_().lastIndexOf(".json") != location.m_135815_().length() - 5) {
            location = new ResourceLocation(location.m_135827_(), location.m_135815_() + ".json");
        }
        if ((jsonString = Util.readResourceLocation(location)) == null) {
            return null;
        }
        JsonElement element = new JsonParser().parse(jsonString);
        if (element instanceof JsonObject) {
            return (JsonObject)element;
        }
        return null;
    }

    public static <T extends Exception> void chunkCachedBlockStateIteration(Vector3ic start, Vector3ic end, Level world, LamdbaExceptionUtils.BiConsumer_WithExceptions<BlockState, Vector3i, T> func) throws T {
        Util.chunkCachedBlockStateIteration(start, end, world, func, new Vector3i());
    }

    public static <T extends Exception> void chunkCachedBlockStateIteration(Vector3ic start, Vector3ic end, Level world, LamdbaExceptionUtils.BiConsumer_WithExceptions<BlockState, Vector3i, T> func, Vector3i scratchVector) throws T {
        int minx = start.x();
        int miny = start.y();
        int minz = start.z();
        int maxx = end.x();
        int maxy = end.y();
        int maxz = end.z();
        int maxX = maxx + 16 & 0xFFFFFFF0;
        int maxY = maxy + 16 & 0xFFFFFFF0;
        int maxZ = maxz + 16 & 0xFFFFFFF0;
        BlockState AIR_STATE = Blocks.f_50016_.m_49966_();
        for (int Z = minz; Z < maxZ; Z += 16) {
            int sectionMinZ = Math.max(Z & 0xFFFFFFF0, minz);
            int sectionMaxZ = Math.min(Z + 16 & 0xFFFFFFF0, maxz + 1);
            for (int X = minx; X < maxX; X += 16) {
                int chunkX = X >> 4;
                int chunkZ = Z >> 4;
                int sectionMinX = Math.max(X & 0xFFFFFFF0, minx);
                int sectionMaxX = Math.min(X + 16 & 0xFFFFFFF0, maxx + 1);
                LevelChunk chunk = (LevelChunk)world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
                if (chunk == null) {
                    for (int x = sectionMinX; x < sectionMaxX; ++x) {
                        for (int y = miny; y < maxy; ++y) {
                            for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                                scratchVector.set(x, y, z);
                                func.accept((Object)AIR_STATE, (Object)scratchVector);
                            }
                        }
                    }
                    continue;
                }
                LevelChunkSection[] chunkSections = chunk.m_7103_();
                int chunkMinSection = chunk.m_151560_();
                for (int Y = miny; Y < maxY; Y += 16) {
                    int sectionMinY = Math.max(Y & 0xFFFFFFF0, miny);
                    int sectionMaxY = Math.min(Y + 16 & 0xFFFFFFF0, maxy + 1);
                    int chunkSectionIndex = (Y >> 4) - chunkMinSection;
                    LevelChunkSection chunkSection = chunkSections[chunkSectionIndex];
                    if (chunkSection == null) {
                        for (int x = sectionMinX; x < sectionMaxX; ++x) {
                            for (int y = sectionMinY; y < sectionMaxY; ++y) {
                                for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                                    scratchVector.set(x, y, z);
                                    func.accept((Object)AIR_STATE, (Object)scratchVector);
                                }
                            }
                        }
                        continue;
                    }
                    for (int y = sectionMinY; y < sectionMaxY; ++y) {
                        for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                            for (int x = sectionMinX; x < sectionMaxX; ++x) {
                                scratchVector.set(x, y, z);
                                BlockState state = chunkSection.m_62982_(x & 0xF, y & 0xF, z & 0xF);
                                func.accept((Object)state, (Object)scratchVector);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void markRangeDirty(Level world, Vector2i start, Vector2i end) {
        for (int X = start.x; X < (end.x + 16 & 0xFFFFFFF0); X += 16) {
            for (int Z = start.y; Z < (end.y + 16 & 0xFFFFFFF0); Z += 16) {
                int chunkX = X >> 4;
                int chunkZ = Z >> 4;
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                chunk.m_8092_(true);
            }
        }
    }

    public static void markRangeDirty(Level world, Vector3ic start, Vector3ic end) {
        for (int X = start.x(); X < (end.x() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Z = start.z(); Z < (end.z() + 16 & 0xFFFFFFF0); Z += 16) {
                int chunkX = X >> 4;
                int chunkZ = Z >> 4;
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                chunk.m_8092_(true);
            }
        }
    }

    public static void setBlockStateWithoutUpdate(BlockPos pos, BlockState state) {
        Util.setBlockStateWithoutUpdate(pos.m_121878_(), state);
    }

    public static void setBlockStateWithoutUpdate(long pos, BlockState state) {
        endOfTickStates.put(pos, (Object)state);
    }

    public static void setBlockStateWithoutUpdate(Long2ObjectOpenHashMap<BlockState> map) {
        endOfTickStates.putAll(map);
    }

    public static void setBlockStates(Map<BlockPos, BlockState> newStates, Level world) {
        HashMap<BlockPos, HashMap> stateChunks = new HashMap<BlockPos, HashMap>();
        BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos();
        newStates.forEach((pos, state) -> {
            chunkPos.m_122178_(pos.m_123341_() >> 4, 0, pos.m_123343_() >> 4);
            LinkedHashMap<BlockPos, BlockState> chunksNewStates = (LinkedHashMap<BlockPos, BlockState>)stateChunks.get(chunkPos);
            if (chunksNewStates == null) {
                chunksNewStates = new LinkedHashMap<BlockPos, BlockState>(8192);
                stateChunks.put(chunkPos.m_7949_(), chunksNewStates);
            }
            chunksNewStates.put((BlockPos)pos, (BlockState)state);
        });
        stateChunks.forEach((cPos, states) -> {
            LevelChunk chunk = world.m_6325_(cPos.m_123341_(), cPos.m_123343_());
            LevelChunkSection[] chunkSections = chunk.m_7103_();
            states.forEach((bPos, state) -> {
                LevelChunkSection section = chunkSections[(bPos.m_123342_() >> 4) - chunk.m_151560_()];
                if (section != null) {
                    section.m_62986_(bPos.m_123341_() & 0xF, bPos.m_123342_() & 0xF, bPos.m_123343_() & 0xF, state);
                    Util.markForUpdatePacket(bPos);
                }
            });
            chunk.m_8092_(true);
        });
    }

    public static void setBlockStatesAndUpdateLight(Long2ObjectMap<BlockState> newStates, Level world) {
        stateChunks.clear();
        ((Long2ObjectMap.FastEntrySet)newStates.long2ObjectEntrySet()).fastIterator().forEachRemaining(entry -> {
            long posLong = entry.getLongKey();
            BlockState state = (BlockState)entry.getValue();
            chunkPos.m_122178_(BlockPos.m_121983_((long)posLong) >> 4, 0, BlockPos.m_122015_((long)posLong) >> 4);
            Long2ObjectLinkedOpenHashMap chunksNewStates = (Long2ObjectLinkedOpenHashMap)stateChunks.get(chunkPos.m_121878_());
            if (chunksNewStates == null) {
                if (existingMaps.isEmpty()) {
                    chunksNewStates = new Long2ObjectLinkedOpenHashMap();
                } else {
                    chunksNewStates = (Long2ObjectLinkedOpenHashMap)existingMaps.pop();
                    chunksNewStates.clear();
                }
                stateChunks.put(chunkPos.m_121878_(), (Object)chunksNewStates);
            }
            chunksNewStates.put(posLong, (Object)state);
        });
        stateChunks.long2ObjectEntrySet().fastIterator().forEachRemaining(entry -> {
            long cPosLong = entry.getLongKey();
            Long2ObjectLinkedOpenHashMap states = (Long2ObjectLinkedOpenHashMap)entry.getValue();
            ServerChunkCache chunkSource = (ServerChunkCache)world.m_7726_();
            LevelChunk chunk = (LevelChunk)chunkSource.m_7587_(BlockPos.m_121983_((long)cPosLong), BlockPos.m_122015_((long)cPosLong), ChunkStatus.f_62326_, true);
            assert (chunk != null);
            LevelChunkSection[] chunkSections = chunk.m_7103_();
            states.long2ObjectEntrySet().fastIterator().forEachRemaining(entry1 -> {
                long bPosLong = entry1.getLongKey();
                BlockState state = (BlockState)entry1.getValue();
                int sectionIndex = (BlockPos.m_122008_((long)bPosLong) >> 4) - chunk.m_151560_();
                LevelChunkSection section = chunkSections[sectionIndex];
                if (section != null) {
                    section.m_63019_().m_156470_(BlockPos.m_121983_((long)bPosLong) & 0xF, BlockPos.m_122008_((long)bPosLong) & 0xF, BlockPos.m_122015_((long)bPosLong) & 0xF, (Object)state);
                    world.m_5518_().m_7174_((BlockPos)chunkPos.m_122188_(bPosLong));
                    chunkSource.m_8450_((BlockPos)chunkPos.m_122188_(bPosLong));
                }
            });
            existingMaps.add((Object)states);
            chunk.m_8092_(true);
        });
    }

    public static void setBlockStates(Long2ObjectMap<BlockState> newStates, Level world) {
        stateChunks.clear();
        ((Long2ObjectMap.FastEntrySet)newStates.long2ObjectEntrySet()).fastIterator().forEachRemaining(entry -> {
            long posLong = entry.getLongKey();
            BlockState state = (BlockState)entry.getValue();
            chunkPos.m_122178_(BlockPos.m_121983_((long)posLong) >> 4, 0, BlockPos.m_122015_((long)posLong) >> 4);
            Long2ObjectLinkedOpenHashMap chunksNewStates = (Long2ObjectLinkedOpenHashMap)stateChunks.get(chunkPos.m_121878_());
            if (chunksNewStates == null) {
                if (existingMaps.isEmpty()) {
                    chunksNewStates = new Long2ObjectLinkedOpenHashMap();
                } else {
                    chunksNewStates = (Long2ObjectLinkedOpenHashMap)existingMaps.pop();
                    chunksNewStates.clear();
                }
                stateChunks.put(chunkPos.m_121878_(), (Object)chunksNewStates);
            }
            chunksNewStates.put(posLong, (Object)state);
        });
        stateChunks.long2ObjectEntrySet().fastIterator().forEachRemaining(entry -> {
            long cPosLong = entry.getLongKey();
            Long2ObjectLinkedOpenHashMap states = (Long2ObjectLinkedOpenHashMap)entry.getValue();
            LevelChunk chunk = world.m_6325_(BlockPos.m_121983_((long)cPosLong), BlockPos.m_122015_((long)cPosLong));
            LevelChunkSection[] chunkSections = chunk.m_7103_();
            states.long2ObjectEntrySet().fastIterator().forEachRemaining(entry1 -> {
                long bPosLong = entry1.getLongKey();
                BlockState state = (BlockState)entry1.getValue();
                LevelChunkSection section = chunkSections[(BlockPos.m_122008_((long)bPosLong) >> 4) - chunk.m_151560_()];
                if (section != null) {
                    BlockState oldState = (BlockState)section.m_63019_().m_63091_(BlockPos.m_121983_((long)bPosLong) & 0xF, BlockPos.m_122008_((long)bPosLong) & 0xF, BlockPos.m_122015_((long)bPosLong) & 0xF, (Object)state);
                    Util.markForUpdatePacket(bPosLong);
                    if (oldState == state) {
                        return;
                    }
                    if (oldState.m_60734_() != state.m_60734_()) {
                        throw new IllegalStateException("Phosphophyllite Util fast setBlockStates does not handle changing block type");
                    }
                }
            });
            existingMaps.add((Object)states);
            chunk.m_8092_(true);
        });
    }

    private static void markForUpdatePacket(BlockPos pos) {
        long chunkPos = SectionPos.m_175568_((BlockPos)pos);
        boolean[] updateArray = (boolean[])updateArrays.get(chunkPos);
        if (updateArray == null) {
            if (existingArrays.isEmpty()) {
                updateArray = new boolean[4096];
            } else {
                updateArray = (boolean[])existingArrays.pop();
                Arrays.fill(updateArray, false);
            }
            updateArrays.put(chunkPos, (Object)updateArray);
        }
        short sectionPos = SectionPos.m_123218_((BlockPos)pos);
        assert (sectionPos >= 0 && sectionPos < 4096);
        updateArray[sectionPos] = true;
    }

    private static void markForUpdatePacket(long blockPosLong) {
        long sectionPosLong = SectionPos.m_123235_((long)blockPosLong);
        boolean[] updateArray = (boolean[])updateArrays.get(sectionPosLong);
        if (updateArray == null) {
            if (existingArrays.isEmpty()) {
                updateArray = new boolean[4096];
            } else {
                updateArray = (boolean[])existingArrays.pop();
                Arrays.fill(updateArray, false);
            }
            updateArrays.put(sectionPosLong, (Object)updateArray);
        }
        int i = SectionPos.m_123207_((int)BlockPos.m_121983_((long)blockPosLong));
        int j = SectionPos.m_123207_((int)BlockPos.m_122008_((long)blockPosLong));
        int k = SectionPos.m_123207_((int)BlockPos.m_122015_((long)blockPosLong));
        short sectionPos = (short)(i << 8 | k << 4 | j);
        assert (sectionPos >= 0 && sectionPos < 4096);
        updateArray[sectionPos] = true;
    }

    public static void updateBlockStates(Level level) {
        if (!endOfTickStates.isEmpty()) {
            Util.setBlockStates(endOfTickStates, level);
            endOfTickStates.clear();
        }
    }

    public static void clientTick() {
        Util.lastLevel[1] = null;
    }

    public static void serverTick() {
        Util.lastLevel[0] = null;
    }

    public static void worldTickEndEvent(Level level) {
        if (!endOfTickStates.isEmpty()) {
            Util.setBlockStates(endOfTickStates, level);
            endOfTickStates.clear();
        }
        if (updateArrays.isEmpty()) {
            return;
        }
        SpecialShortArraySet shortSet = new SpecialShortArraySet();
        updateArrays.long2ObjectEntrySet().fastIterator().forEachRemaining(entry -> {
            long entryKey = entry.getLongKey();
            boolean[] entryArray = (boolean[])entry.getValue();
            SectionPos sectionPos = SectionPos.m_123184_((long)entryKey);
            LevelChunkSection levelSection = level.m_6325_(sectionPos.m_123170_(), sectionPos.m_123222_()).m_7103_()[sectionPos.m_123206_() - level.m_151560_()];
            if (levelSection != null) {
                shortSet.clear();
                for (int i = 0; i < 4096; ++i) {
                    if (!entryArray[i]) continue;
                    shortSet.fadd((short)i);
                }
                ClientboundSectionBlocksUpdatePacket packet = new ClientboundSectionBlocksUpdatePacket(sectionPos, (ShortSet)shortSet, levelSection);
                ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(sectionPos.m_123251_(), false).forEach(serverPlayer -> serverPlayer.f_8906_.m_9829_((Packet)packet));
            }
            existingArrays.add((Object)entryArray);
        });
        updateArrays.clear();
    }

    public static Direction directionFromPositions(BlockPos reference, BlockPos neighbor) {
        int xDifference = neighbor.m_123341_() - reference.m_123341_();
        int yDifference = neighbor.m_123342_() - reference.m_123342_();
        int zDifference = neighbor.m_123343_() - reference.m_123343_();
        if (Math.abs(xDifference) + Math.abs(yDifference) + Math.abs(zDifference) > 1) {
            throw new IllegalArgumentException("positions not neighbors");
        }
        if (xDifference == -1) {
            return Direction.WEST;
        }
        if (xDifference == 1) {
            return Direction.EAST;
        }
        if (yDifference == -1) {
            return Direction.DOWN;
        }
        if (yDifference == 1) {
            return Direction.UP;
        }
        if (zDifference == -1) {
            return Direction.NORTH;
        }
        if (zDifference == 1) {
            return Direction.SOUTH;
        }
        throw new IllegalArgumentException("identical positions gives");
    }

    public static boolean isWrench(Item item) {
        return item.m_204114_().m_203656_(WRENCH_TAG_0) || item.m_204114_().m_203656_(WRENCH_TAG_1);
    }

    @Deprecated(forRemoval=true)
    public static boolean isEntireAreaLoaded(Level level, Vector3ic min, Vector3ic max) {
        return Util.isEntireAreaLoaded(level, SectionPos.m_123171_((int)min.x()), SectionPos.m_123171_((int)min.z()), SectionPos.m_123171_((int)max.x()), SectionPos.m_123171_((int)max.z()));
    }

    @Deprecated(forRemoval=true)
    public static boolean isEntireAreaLoaded(Level level, int minCX, int minCZ, int maxCX, int maxCZ) {
        for (int i = minCX; i <= maxCX; ++i) {
            for (int j = minCZ; j <= maxCZ; ++j) {
                if (level.m_6522_(i, j, ChunkStatus.f_62326_, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static int clampToInt(long val) {
        return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, val));
    }

    private static class SpecialShortArraySet
    extends ShortArraySet {
        private int size = 0;
        private final short[] elements = new short[4096];

        public int size() {
            return this.size;
        }

        public ShortIterator iterator() {
            return new ShortIterator(){
                int index = 0;

                public boolean hasNext() {
                    return this.index < size;
                }

                public short nextShort() {
                    return elements[this.index++];
                }
            };
        }

        public void clear() {
            this.size = 0;
        }

        public void fadd(short val) {
            this.elements[this.size++] = val;
        }
    }
}

