/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.threading;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.roguelogix.phosphophyllite.threading.Event;

public class WorkQueue {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final ArrayList<DequeueThread> dequeueThreads = new ArrayList();
    private RuntimeException toRethrow;

    public WorkQueue() {
        this.dequeueThreads.forEach(DequeueThread::finish);
    }

    public WorkQueue addProcessingThread() {
        return this.addProcessingThreads(1, null);
    }

    public WorkQueue addProcessingThreads(int threads) {
        return this.addProcessingThreads(threads, null);
    }

    public WorkQueue addProcessingThreads(int threads, String name) {
        for (int i = 0; i < threads; ++i) {
            this.dequeueThreads.add(new DequeueThread(this.queue, name == null ? null : name + i));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.dequeueThreads.forEach(DequeueThread::finish);
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
    }

    protected void finalize() {
        this.finish();
    }

    public Event enqueue(Runnable runnable, Event ... events) {
        if (this.toRethrow != null) {
            throw this.toRethrow;
        }
        WorkItem item = new WorkItem(this.queue, runnable, events);
        return item.waitEvent;
    }

    public void enqueueUntracked(Runnable runnable) {
        this.queue.add(runnable);
    }

    public boolean runOne() {
        if (!this.dequeueThreads.isEmpty()) {
            return false;
        }
        Runnable toRun = (Runnable)this.queue.poll();
        if (toRun != null) {
            toRun.run();
            return true;
        }
        return false;
    }

    public boolean runAll() {
        Runnable toRun;
        if (!this.dequeueThreads.isEmpty()) {
            return false;
        }
        boolean ranSomething = false;
        while ((toRun = (Runnable)this.queue.poll()) != null) {
            toRun.run();
            ranSomething = true;
        }
        return ranSomething;
    }

    private class DequeueThread
    implements Runnable {
        private final WeakReference<BlockingQueue<Runnable>> queue;
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public DequeueThread(BlockingQueue<Runnable> queue, String name) {
            this.queue = new WeakReference<BlockingQueue<Runnable>>(queue);
            Thread thread = new Thread(this);
            if (name != null) {
                thread.setName(name);
            }
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            while (!this.stop.get()) {
                Runnable nextItem;
                BlockingQueue queue = (BlockingQueue)this.queue.get();
                if (queue == null) {
                    return;
                }
                try {
                    nextItem = (Runnable)queue.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    nextItem.run();
                }
                catch (RuntimeException e) {
                    WorkQueue.this.toRethrow = e;
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Minecraft.m_91332_((CrashReport)new CrashReport("Exception rolled back to Phosphophyllite WorkQueue", e));
                }
            }
        }

        public void finish() {
            this.stop.set(true);
        }
    }

    private static class WorkItem
    implements Runnable {
        final Event waitEvent = new Event();
        final Event readyEvent = new Event();
        final Runnable work;
        final AtomicLong unTriggeredWaitEvents = new AtomicLong(Long.MAX_VALUE);

        WorkItem(Queue<Runnable> queue, Runnable work, Event[] waitEvents) {
            this.work = work;
            if (waitEvents.length == 0) {
                queue.add(this);
                return;
            }
            this.unTriggeredWaitEvents.set(waitEvents.length);
            for (Event event : waitEvents) {
                if (event == null && this.unTriggeredWaitEvents.decrementAndGet() == 0L) {
                    this.readyEvent.trigger();
                }
                assert (event != null);
                event.registerCallback(() -> {
                    if (this.unTriggeredWaitEvents.decrementAndGet() == 0L) {
                        Event event = this.readyEvent;
                        synchronized (event) {
                            this.readyEvent.trigger();
                        }
                    }
                });
            }
            this.readyEvent.registerCallback(() -> queue.add(this));
        }

        @Override
        public void run() {
            try {
                this.work.run();
            }
            finally {
                this.waitEvent.trigger();
            }
        }
    }
}

