/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.repack.tnjson;

import java.util.Map;
import net.roguelogix.phosphophyllite.repack.tnjson.IGetCollection;
import net.roguelogix.phosphophyllite.repack.tnjson.JsonParser;
import net.roguelogix.phosphophyllite.repack.tnjson.ParseException;
import net.roguelogix.phosphophyllite.repack.tnjson.TnJsonBuilder;

public class TnJson {
    private static final TnJsonBuilder SET_HARD = TnJsonBuilder.init();
    private static final TnJsonBuilder SET_LIGHT = TnJsonBuilder.init().readable();
    private static final TnJsonBuilder SET_FORMATTED = TnJsonBuilder.init().readable().formated();
    private static final TnJsonBuilder SET_JSON5 = TnJsonBuilder.init().readable().formated().withoutKeyQuote().allowMultiRowString();
    private static final TnJsonBuilder SET_JSON5COMPACT = TnJsonBuilder.init().readable().withoutKeyQuote().singleQuote();
    public static final String DEFAULT_LIST_KEY = "list";

    public static TnJsonBuilder builder() {
        return new TnJsonBuilder();
    }

    public static String toJson(Object data) {
        return SET_HARD.buildJson(data);
    }

    public static String toJson(Object data, Mode mode) {
        switch (mode) {
            case HARD: {
                return SET_HARD.buildJson(data);
            }
            case LIGHT: {
                return SET_LIGHT.buildJson(data);
            }
            case FORMATTED: {
                return SET_FORMATTED.buildJson(data);
            }
            case JSON5: {
                return SET_JSON5.buildJson(data);
            }
            case JSON5COMPACT: {
                return SET_JSON5COMPACT.buildJson(data);
            }
        }
        return SET_HARD.buildJson(data);
    }

    public static Map<String, Object> parse(String data) {
        try {
            JsonParser p = new JsonParser();
            return p.doParse(data);
        }
        catch (ParseException px) {
            throw new ParseException(px.getMessage(), px.getPosition(), px.getPath());
        }
    }

    public static Map<String, Object> parse(String data, IGetCollection listener) {
        try {
            JsonParser p = new JsonParser(listener);
            return p.doParse(data);
        }
        catch (ParseException px) {
            throw new ParseException(px.getMessage(), px.getPosition(), px.getPath());
        }
    }

    TnJson() {
    }

    public String buildJson(Object data) {
        return SET_HARD.buildJson(data);
    }

    public static enum Mode {
        HARD,
        LIGHT,
        FORMATTED,
        JSON5,
        JSON5COMPACT;

    }
}

