/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.networking;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class SimplePhosChannel {
    private final SimpleChannel simpleChannel;
    private final Consumer<PhosphophylliteCompound> callbackFunction;

    public SimplePhosChannel(ResourceLocation id, String version, Consumer<PhosphophylliteCompound> callbackFunction) {
        this.simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)id, () -> version, version::equals, version::equals);
        this.simpleChannel.registerMessage(1, PhosphophylliteCompound.class, SimplePhosChannel::encodePacket, SimplePhosChannel::decodePacket, this::handler);
        this.callbackFunction = callbackFunction;
    }

    private static void encodePacket(PhosphophylliteCompound packet, FriendlyByteBuf buf) {
        ByteArrayList robn = packet.toROBN();
        buf.m_130130_(robn.size());
        for (int i = 0; i < robn.size(); ++i) {
            buf.writeByte((int)robn.getByte(i));
        }
    }

    private static PhosphophylliteCompound decodePacket(FriendlyByteBuf buf) {
        return new PhosphophylliteCompound(buf.m_130052_());
    }

    private void handler(PhosphophylliteCompound compound, @Nonnull Supplier<NetworkEvent.Context> ctxs) {
        NetworkEvent.Context ctx = ctxs.get();
        ctx.enqueueWork(() -> this.callbackFunction.accept(compound));
        ctx.setPacketHandled(true);
    }

    public void sendToServer(PhosphophylliteCompound compound) {
        this.simpleChannel.sendToServer((Object)compound);
    }

    public void sendToPlayer(ServerPlayer serverPlayer, PhosphophylliteCompound compound) {
        this.simpleChannel.sendTo((Object)compound, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

