/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.modular.tile.IIsTickingTracker;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.ICoreMultiblockTileModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;
import org.jetbrains.annotations.Contract;

@NonnullDefault
public final class MultiblockTileModule<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends TileModule<TileType>
implements IIsTickingTracker {
    @Nullable
    private ControllerType controller;
    boolean preExistingBlock = false;
    boolean allowAttach = false;
    long lastSavedTick = 0L;
    final MultiblockTileModule<TileType, BlockType, ControllerType>[] neighbors = new MultiblockTileModule[6];
    final BlockEntity[] neighborTiles = new BlockEntity[6];
    private final ObjectArrayList<ICoreMultiblockTileModule<TileType, BlockType, ControllerType>> coreMultiblockTileModules = new ObjectArrayList();

    @OnModLoad
    private static void onModLoad() {
        ModuleRegistry.registerTileModule(IMultiblockTile.class, MultiblockTileModule::new);
    }

    public MultiblockTileModule(IModularTile blockEntity) {
        super(blockEntity);
    }

    @Override
    public void postModuleConstruction() {
        for (TileModule<?> module : ((IModularTile)((BlockEntity)this.iface)).modules()) {
            if (!(module instanceof ICoreMultiblockTileModule)) continue;
            this.coreMultiblockTileModules.add((Object)((ICoreMultiblockTileModule)((Object)module)));
        }
    }

    @Override
    public void startTicking() {
        this.allowAttach = true;
        this.attachToNeighborsLater();
    }

    @Override
    public void stopTicking() {
        if (this.controller != null) {
            this.allowAttach = false;
            this.coreMultiblockTileModules.forEach(ICoreMultiblockTileModule::aboutToUnloadDetach);
            ((MultiblockController)this.controller).detach(this, true, false, true);
            this.preExistingBlock = true;
        }
    }

    @Override
    public void onRemoved(boolean chunkUnload) {
        if (this.controller != null) {
            if (chunkUnload) {
                this.coreMultiblockTileModules.forEach(ICoreMultiblockTileModule::aboutToUnloadDetach);
            } else {
                this.coreMultiblockTileModules.forEach(ICoreMultiblockTileModule::aboutToRemovedDetach);
            }
            ((MultiblockController)this.controller).detach(this, chunkUnload, false, true);
        }
    }

    @Nullable
    public ControllerType controller() {
        return this.controller;
    }

    @Nullable
    @Contract
    ControllerType controller(@Nullable ControllerType newController) {
        if (this.controller != newController) {
            this.controller = newController;
            this.coreMultiblockTileModules.forEach(ICoreMultiblockTileModule::onControllerChange);
        }
        return this.controller;
    }

    @Override
    public String saveKey() {
        return "phosphophyllite_multiblock";
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        this.preExistingBlock = true;
    }

    @Override
    public CompoundTag writeNBT() {
        return new CompoundTag();
    }

    @Contract(pure=true)
    private boolean shouldConnectTo(IMultiblockTile<?, ?, ?> otherRawTile, Direction direction) {
        ICoreMultiblockTileModule extensionModule;
        int i;
        if (!this.allowAttach) {
            return false;
        }
        if (this.controller != null && !((MultiblockController)this.controller).canAttachTile(otherRawTile)) {
            return false;
        }
        if (otherRawTile.nullableController() != null && !((MultiblockController)otherRawTile.controller()).canAttachTile((IMultiblockTile)this.iface)) {
            return false;
        }
        BlockEntity otherTile = (BlockEntity)otherRawTile;
        MultiblockTileModule otherModule = (MultiblockTileModule)((IModularTile)otherTile).module(IMultiblockTile.class);
        assert (otherModule != null);
        Direction oppositeDirection = direction.m_122424_();
        for (i = 0; i < this.coreMultiblockTileModules.size(); ++i) {
            extensionModule = (ICoreMultiblockTileModule)this.coreMultiblockTileModules.get(i);
            if (extensionModule.shouldConnectTo(otherTile, direction)) continue;
            return false;
        }
        for (i = 0; i < otherModule.coreMultiblockTileModules.size(); ++i) {
            extensionModule = (ICoreMultiblockTileModule)otherModule.coreMultiblockTileModules.get(i);
            if (extensionModule.shouldConnectTo((BlockEntity)this.iface, oppositeDirection)) continue;
            return false;
        }
        return true;
    }

    void updateNeighbors() {
        if (this.controller == null) {
            return;
        }
        this.nullNeighbors();
        BlockPos pos = ((BlockEntity)this.iface).m_58899_();
        for (Direction value : Util.DIRECTIONS) {
            MultiblockTileModule neighbor = ((MultiblockController)this.controller).blocks.getModule(pos.m_123341_() + value.m_122429_(), pos.m_123342_() + value.m_122430_(), pos.m_123343_() + value.m_122431_());
            if (neighbor == null || !this.shouldConnectTo((IMultiblockTile)neighbor.iface, value)) continue;
            this.neighbors[value.m_122411_()] = neighbor;
            this.neighborTiles[value.m_122411_()] = (BlockEntity)neighbor.iface;
        }
        for (int i = 0; i < this.neighbors.length; ++i) {
            MultiblockTileModule<TileType, BlockType, ControllerType> neighbor = this.neighbors[i];
            if (neighbor == null) continue;
            neighbor.neighbors[Direction.m_122376_((int)i).m_122424_().m_122411_()] = this;
            neighbor.neighborTiles[Direction.m_122376_((int)i).m_122424_().m_122411_()] = (BlockEntity)this.iface;
        }
    }

    void nullNeighbors() {
        for (int i = 0; i < this.neighbors.length; ++i) {
            MultiblockTileModule<TileType, BlockType, ControllerType> neighbor = this.neighbors[i];
            if (neighbor != null) {
                neighbor.neighbors[Direction.m_122376_((int)i).m_122424_().m_122411_()] = null;
                neighbor.neighborTiles[Direction.m_122376_((int)i).m_122424_().m_122411_()] = null;
            }
            this.neighbors[i] = null;
            this.neighborTiles[i] = null;
        }
    }

    @Nullable
    public MultiblockTileModule<TileType, BlockType, ControllerType> getNeighbor(Direction direction) {
        return this.neighbors[direction.m_122411_()];
    }

    public void attachToNeighborsLater() {
        if (Objects.requireNonNull(((BlockEntity)this.iface).m_58904_()).f_46443_) {
            return;
        }
        Queues.serverThread.enqueueUntracked(this::attachToNeighborsNow);
    }

    public void attachToNeighborsNow() {
        Level level = ((BlockEntity)this.iface).m_58904_();
        assert (level != null);
        if (level.f_46443_) {
            return;
        }
        if (((BlockEntity)this.iface).m_58901_()) {
            return;
        }
        BlockPos pos = ((BlockEntity)this.iface).m_58899_();
        if (((BlockEntity)this.iface).m_58904_().m_7702_(pos) != this.iface) {
            return;
        }
        this.coreMultiblockTileModules.forEach(ICoreMultiblockTileModule::aboutToAttemptAttach);
        BlockPos.MutableBlockPos possibleTilePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Util.DIRECTIONS) {
            possibleTilePos.m_122190_((Vec3i)pos);
            possibleTilePos.m_122173_(direction);
            BlockEntity tile = Util.getTile(level, (BlockPos)possibleTilePos);
            if (!(tile instanceof IMultiblockTile)) continue;
            IMultiblockTile multiblockTile = (IMultiblockTile)tile;
            MultiblockTileModule multiblockModule = multiblockTile.multiblockModule();
            if (multiblockModule.controller == null || !this.shouldConnectTo(multiblockTile, direction)) continue;
            ((MultiblockController)multiblockModule.controller).attemptAttach(this);
        }
        if (this.controller == null) {
            ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).createController()).attemptAttach(this);
        }
    }

    @Override
    public DebugInfo getDebugInfo() {
        DebugInfo debugInfo = new DebugInfo(this.getClass().getSimpleName());
        ControllerType controller = this.controller();
        if (controller == null) {
            debugInfo.add("Null Multiblock controller");
        } else {
            debugInfo.add(((MultiblockController)controller).getDebugInfo());
        }
        return debugInfo;
    }
}

