/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui.elements;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.ScreenCallbacks;
import net.roguelogix.phosphophyllite.client.gui.api.IRender;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class RenderedElement<T extends AbstractContainerMenu>
extends TooltipElement<T>
implements IRender {
    public boolean renderEnable = true;
    public int u;
    public int v;
    public ScreenCallbacks.OnRender onRender;
    boolean focused = false;

    public RenderedElement(@Nonnull PhosphophylliteScreen<T> parent, int x, int y, int width, int height, int u, int v, @Nullable Component tooltip) {
        super(parent, x, y, width, height, tooltip);
        this.u = u;
        this.v = v;
    }

    @Override
    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.renderEnable && this.onRender != null) {
            this.onRender.trigger(graphics, mouseX, mouseY);
        }
        RenderHelper.clearRenderColor();
    }

    public void blit(@Nonnull GuiGraphics graphics) {
        graphics.m_280163_(RenderHelper.getCurrentResource(), this.x, this.y, (float)this.u, (float)this.v, this.width, this.height, 256, 256);
    }

    public void blit(@Nonnull GuiGraphics graphics, int u, int v) {
        graphics.m_280163_(RenderHelper.getCurrentResource(), this.x, this.y, (float)u, (float)v, this.width, this.height, 256, 256);
    }

    public void blit(@Nonnull GuiGraphics graphics, int width, int height, int u, int v) {
        graphics.m_280163_(RenderHelper.getCurrentResource(), this.x, this.y, (float)u, (float)v, width, height, 256, 256);
    }

    public void blit(@Nonnull GuiGraphics graphics, int x, int y, int u, int v, int width, int height) {
        graphics.m_280163_(RenderHelper.getCurrentResource(), x, y, (float)u, (float)v, width, height, 256, 256);
    }

    @Override
    public void enable() {
        super.enable();
        this.renderEnable = true;
    }

    @Override
    public void disable() {
        super.disable();
        this.renderEnable = false;
    }

    @Override
    public void m_93692_(boolean shouldFocus) {
        this.focused = shouldFocus;
    }

    @Override
    public boolean m_93696_() {
        return this.focused;
    }
}

