/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class MinerRecipeBuilder
implements RecipeBuilder {
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<MinerRecipe> serializer = MinerRecipe.SERIALIZER;
    private final Ingredient ingredient;
    @Nullable
    private final ResourceLocation outputItem;
    @Nullable
    private final String outputTag;
    private final int weight;
    private boolean allowEmpty;
    private boolean itemExists;

    public MinerRecipeBuilder(Ingredient ingredient, @Nullable ResourceLocation outputItem, @Nullable String outputTag, int weight) {
        this.ingredient = ingredient;
        this.outputItem = outputItem;
        this.outputTag = outputTag;
        this.weight = weight;
        this.allowEmpty = false;
        this.itemExists = false;
    }

    public static MinerRecipeBuilder minerRecipe(Ingredient ingredient, Ingredient output, int weight) {
        if (output.f_43902_.length == 1 && output.f_43902_[0] instanceof Ingredient.ItemValue) {
            ResourceLocation item = output.m_43908_()[0].m_41720_().m_204114_().m_205785_().m_135782_();
            return new MinerRecipeBuilder(ingredient, item, null, weight);
        }
        if (output.f_43902_.length == 1 && output.f_43902_[0] instanceof Ingredient.TagValue) {
            return new MinerRecipeBuilder(ingredient, null, ((Ingredient.TagValue)output.f_43902_[0]).f_43959_.f_203868_().toString(), weight);
        }
        return null;
    }

    public static MinerRecipeBuilder minerRecipe(Ingredient ingredient, ResourceLocation output, int weight) {
        return new MinerRecipeBuilder(ingredient, output, null, weight);
    }

    public static MinerRecipeBuilder minerRecipe(Ingredient ingredient, String outputTag, int weight) {
        return new MinerRecipeBuilder(ingredient, null, outputTag, weight);
    }

    public MinerRecipeBuilder unlockedBy(String s, CriterionTriggerInstance criterionTriggerInstance) {
        this.advancement.m_138386_(s, criterionTriggerInstance);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String s) {
        this.group = s;
        return this;
    }

    public Item m_142372_() {
        return null;
    }

    public MinerRecipeBuilder allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public MinerRecipeBuilder itemExists() {
        this.itemExists = true;
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)resourceLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)resourceLocation)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(resourceLocation, this.advancement, new ResourceLocation(resourceLocation.m_135827_(), "recipes/miner/" + resourceLocation.m_135815_()), this.group == null ? "" : this.group, this.serializer, this.ingredient, this.outputItem, this.outputTag, this.weight, this.allowEmpty, this.itemExists));
    }

    public void m_176498_(Consumer<FinishedRecipe> p_176499_) {
        throw new IllegalStateException("Recipe must be saved with a unique ID");
    }

    public void m_176500_(Consumer<FinishedRecipe> p_176501_, String p_176502_) {
        throw new IllegalStateException("Recipe must be saved with a unique ID");
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        @Nullable
        private String group;
        private final RecipeSerializer<MinerRecipe> serializer;
        private final Ingredient ingredient;
        @Nullable
        private final ResourceLocation outputItem;
        @Nullable
        private final String outputTag;
        private final int weight;
        private final boolean allowEmpty;
        private final boolean itemExists;

        public Result(ResourceLocation id, Advancement.Builder advancement, @Nullable ResourceLocation advancementId, String group, RecipeSerializer<MinerRecipe> serializer, Ingredient ingredient, ResourceLocation outputItem, String outputTag, int weight, boolean allowEmpty, boolean itemExists) {
            this.id = id;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.group = group;
            this.serializer = serializer;
            this.ingredient = ingredient;
            this.outputItem = outputItem;
            this.outputTag = outputTag;
            this.weight = weight;
            this.allowEmpty = allowEmpty;
            this.itemExists = itemExists;
        }

        public void m_7917_(JsonObject jsonObject) {
            JsonArray conditions;
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            JsonObject output = new JsonObject();
            if (this.outputTag != null) {
                output.addProperty("tag", this.outputTag);
                jsonObject.add("result", (JsonElement)output);
            } else {
                JsonObject item = new JsonObject();
                item.addProperty("item", this.outputItem.toString());
                jsonObject.add("result", (JsonElement)item);
            }
            if (!this.allowEmpty) {
                conditions = new JsonArray();
                if (this.outputTag != null) {
                    conditions.add((JsonElement)this.makeTagNotEmptyCondition(this.outputTag));
                }
                jsonObject.add("conditions", (JsonElement)conditions);
            }
            if (this.itemExists) {
                conditions = new JsonArray();
                conditions.add((JsonElement)this.makeItemExistsCondition(this.outputItem));
                jsonObject.add("conditions", (JsonElement)conditions);
            }
            jsonObject.addProperty("weight", (Number)this.weight);
        }

        public JsonObject makeItemExistsCondition(ResourceLocation item) {
            JsonObject condition = new JsonObject();
            condition.addProperty("type", "forge:item_exists");
            condition.addProperty("item", item.toString());
            return condition;
        }

        public JsonObject makeTagNotEmptyCondition(String tag) {
            JsonObject condition = new JsonObject();
            condition.addProperty("type", "forge:not");
            JsonObject value = new JsonObject();
            value.addProperty("type", "forge:tag_empty");
            value.addProperty("tag", tag);
            condition.add("value", (JsonElement)value);
            return condition;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

