/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class ModNameCache {
    private static final Map<String, String> ID_2_NAME = Maps.newHashMap();

    public static void init() {
        ModList.get().forEachModFile(modFile -> {
            for (IModInfo info : modFile.getModInfos()) {
                ID_2_NAME.put(info.getModId(), info.getDisplayName());
                ID_2_NAME.put(info.getModId().toLowerCase(), info.getDisplayName());
            }
        });
        ID_2_NAME.put("minecraft", "Minecraft");
    }

    public static String getModName(ItemStack stack) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return key == null ? "?" : ModNameCache.getModName(key.m_135827_());
    }

    public static String getModName(String modId) {
        return ID_2_NAME.getOrDefault(modId, modId);
    }
}

