/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CompiledFluidModule1
extends CompiledModule {
    public static final String NBT_FORCE_EMPTY = "ForceEmpty";
    public static final String NBT_MAX_TRANSFER = "MaxTransfer";
    public static final String NBT_FLUID_DIRECTION = "FluidDir";
    public static final String NBT_REGULATE_ABSOLUTE = "RegulateAbsolute";
    public static final int BUCKET_VOLUME = 1000;
    private final int maxTransfer;
    private final FluidModule1.FluidDirection fluidDirection;
    private final boolean forceEmpty;
    private final boolean regulateAbsolute;

    public CompiledFluidModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        this.maxTransfer = compound.m_128451_(NBT_MAX_TRANSFER);
        this.fluidDirection = FluidModule1.FluidDirection.values()[compound.m_128445_(NBT_FLUID_DIRECTION)];
        this.forceEmpty = compound.m_128471_(NBT_FORCE_EMPTY);
        this.regulateAbsolute = compound.m_128471_(NBT_REGULATE_ABSOLUTE);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean didWork;
        BlockPos pos;
        if (this.getTarget() == null) {
            return false;
        }
        LazyOptional routerCap = router.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!routerCap.isPresent()) {
            return false;
        }
        Level world = Objects.requireNonNull(router.m_58904_());
        LazyOptional worldFluidCap = FluidUtil.getFluidHandler((Level)world, (BlockPos)(pos = this.getTarget().gPos.m_122646_()), (Direction)this.getFacing().m_122424_());
        if (worldFluidCap.isPresent()) {
            didWork = switch (this.fluidDirection) {
                default -> throw new IncompatibleClassChangeError();
                case FluidModule1.FluidDirection.IN -> worldFluidCap.map(srcHandler -> routerCap.map(dstHandler -> this.doTransfer(router, (IFluidHandler)srcHandler, (IFluidHandler)dstHandler, FluidModule1.FluidDirection.IN)).orElse(false)).orElse(false);
                case FluidModule1.FluidDirection.OUT -> routerCap.map(srcHandler -> worldFluidCap.map(dstHandler -> this.doTransfer(router, (IFluidHandler)srcHandler, (IFluidHandler)dstHandler, FluidModule1.FluidDirection.OUT)).orElse(false)).orElse(false);
            };
        } else {
            boolean playSound = router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0;
            switch (this.fluidDirection) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case IN: {
                    boolean bl = this.tryPickupFluid((LazyOptional<IFluidHandlerItem>)routerCap, world, pos, playSound);
                    break;
                }
                case OUT: {
                    boolean bl = didWork = this.tryPourOutFluid((LazyOptional<IFluidHandlerItem>)routerCap, world, pos, playSound);
                }
            }
        }
        if (didWork) {
            routerCap.ifPresent(h -> router.setBufferItemStack(h.getContainer()));
        }
        return didWork;
    }

    private boolean tryPickupFluid(LazyOptional<IFluidHandlerItem> routerCap, Level world, BlockPos pos, boolean playSound) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof BucketPickup)) {
            return false;
        }
        BucketPickup bucketPickup = (BucketPickup)block;
        FluidState fluidState = state.m_60819_();
        Fluid fluid = fluidState.m_76152_();
        if (fluid == Fluids.f_76191_ || !fluid.m_7444_(fluidState) || !this.getFilter().testFluid(fluid)) {
            return false;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = routerCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)false)).orElse(FluidStack.EMPTY);
        if (maybeSent.getAmount() != 1000) {
            return false;
        }
        bucketPickup.m_142598_((LevelAccessor)world, pos, state);
        FluidStack transferred = routerCap.map(destHandler -> FluidUtil.tryFluidTransfer((IFluidHandler)destHandler, (IFluidHandler)tank, (int)1000, (boolean)true)).orElse(FluidStack.EMPTY);
        if (!transferred.isEmpty() && playSound) {
            this.playFillSound(world, pos, fluid);
        }
        return !transferred.isEmpty();
    }

    private boolean tryPourOutFluid(LazyOptional<IFluidHandlerItem> routerFluidCap, Level world, BlockPos pos, boolean playSound) {
        if (!(this.forceEmpty || world.m_46859_(pos) || world.m_8055_(pos).m_60734_() instanceof LiquidBlockContainer)) {
            return false;
        }
        boolean didWork = routerFluidCap.map(handler -> {
            LiquidBlockContainer liq;
            FluidStack toPlace = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (toPlace.getAmount() < 1000) {
                return false;
            }
            Fluid fluid = toPlace.getFluid();
            if (!this.getFilter().testFluid(toPlace.getFluid())) {
                return false;
            }
            BlockState blockstate = world.m_8055_(pos);
            boolean isReplaceable = blockstate.m_60722_(fluid);
            Block block = blockstate.m_60734_();
            if (world.m_46859_(pos) || isReplaceable || block instanceof LiquidBlockContainer && (liq = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockstate, toPlace.getFluid())) {
                if (world.m_6042_().f_63857_() && fluid.m_205067_(FluidTags.f_13131_)) {
                    this.playEvaporationEffects(world, pos, fluid);
                } else if (block instanceof LiquidBlockContainer) {
                    FluidState still;
                    LiquidBlockContainer liq2 = (LiquidBlockContainer)block;
                    if (fluid instanceof FlowingFluid) {
                        FlowingFluid ff = (FlowingFluid)fluid;
                        v0 = ff.m_76068_(false);
                    } else {
                        v0 = still = fluid.m_76145_();
                    }
                    if (liq2.m_7361_((LevelAccessor)world, pos, blockstate, still) && playSound) {
                        this.playEmptySound(world, pos, fluid);
                    }
                } else {
                    if (playSound) {
                        this.playEmptySound(world, pos, fluid);
                    }
                    if (isReplaceable) {
                        world.m_46961_(pos, true);
                    }
                    world.m_7731_(pos, fluid.m_76145_().m_76188_(), 11);
                }
                return true;
            }
            return false;
        }).orElse(false);
        if (didWork) {
            routerFluidCap.ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
        }
        return didWork;
    }

    private void playEmptySound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY);
        if (soundevent != null) {
            world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void playFillSound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);
        if (soundEvent != null) {
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void playEvaporationEffects(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(SoundActions.FLUID_VAPORIZE);
        if (soundEvent != null) {
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        for (int l = 0; l < 8; ++l) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean doTransfer(ModularRouterBlockEntity router, IFluidHandler src, IFluidHandler dest, FluidModule1.FluidDirection direction) {
        int amount;
        FluidStack newStack;
        if (this.getRegulationAmount() > 0) {
            if (direction == FluidModule1.FluidDirection.IN && this.checkFluidInTank(src) <= this.getRegulationAmount()) {
                return false;
            }
            if (direction == FluidModule1.FluidDirection.OUT && this.checkFluidInTank(dest) >= this.getRegulationAmount()) {
                return false;
            }
        }
        if (!(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)(amount = Math.min(this.getMaxTransfer(), router.getCurrentFluidTransferAllowance(direction))), (boolean)false)).isEmpty() && this.getFilter().testFluid(newStack.getFluid()) && !(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)newStack.getAmount(), (boolean)true)).isEmpty()) {
            router.transferredFluid(newStack.getAmount(), direction);
            return true;
        }
        return false;
    }

    private int checkFluidInTank(IFluidHandler handler) {
        int total = 0;
        int max = 0;
        if (this.isRegulateAbsolute()) {
            for (int idx = 0; idx < handler.getTanks(); ++idx) {
                total += handler.getFluidInTank(idx).getAmount();
            }
            return total;
        }
        for (int idx = 0; idx < handler.getTanks(); ++idx) {
            max += handler.getTankCapacity(idx);
            total += handler.getFluidInTank(idx).getAmount();
        }
        return max == 0 ? 0 : total * 100 / max;
    }

    public FluidModule1.FluidDirection getFluidDirection() {
        return this.fluidDirection;
    }

    public int getMaxTransfer() {
        return this.maxTransfer == 0 ? 1000 : this.maxTransfer;
    }

    public boolean isForceEmpty() {
        return this.forceEmpty;
    }

    public boolean isRegulateAbsolute() {
        return this.regulateAbsolute;
    }
}

