/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;

public class PlayerModule
extends ModuleItem
implements IPlayerOwned {
    private static final TintColor TINT_COLOR = new TintColor(255, 208, 144);

    public PlayerModule() {
        super(ModItems.defaultProps(), CompiledPlayerModule::new);
    }

    @Override
    public void addSettingsInformation(ItemStack itemstack, List<Component> list) {
        super.addSettingsInformation(itemstack, list);
        CompiledPlayerModule cpm = new CompiledPlayerModule(null, itemstack);
        String owner = cpm.getPlayerName() == null ? "-" : cpm.getPlayerName();
        list.add(MiscUtil.settingsStr(ChatFormatting.YELLOW.toString(), (Component)ClientUtil.xlate("modularrouters.itemText.security.owner", owner)));
        String s = String.format(ChatFormatting.YELLOW + "%s: " + ChatFormatting.AQUA + "%s %s %s", I18n.m_118938_((String)"modularrouters.itemText.misc.operation", (Object[])new Object[0]), I18n.m_118938_((String)"block.modularrouters.modular_router", (Object[])new Object[0]), cpm.getOperation().getSymbol(), I18n.m_118938_((String)("modularrouters.guiText.label.playerSect." + cpm.getSection()), (Object[])new Object[0]));
        list.add((Component)Component.m_237113_((String)s));
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return (MenuType)ModMenuTypes.PLAYER_MENU.get();
    }

    @Override
    public boolean isDirectional() {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ctx.m_43723_() != null && ctx.m_43723_().m_20161_()) {
            this.setOwner(ctx.m_43722_(), ctx.m_43723_());
            ctx.m_43723_().m_5661_((Component)Component.m_237110_((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{ctx.m_43723_().m_5446_()}), false);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.playerModuleEnergyCost.get();
    }

    @Override
    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        TargetedModule.TargetValidation v = ModularRouters.getDimensionBlacklist().test(player.m_9236_().m_46472_().m_135782_()) ? TargetedModule.TargetValidation.BAD_DIMENSION : TargetedModule.TargetValidation.OK;
        MutableComponent msg = Component.m_237115_((String)v.translationKey()).m_130940_(v.getColor());
        player.m_5661_((Component)msg, false);
    }
}

