/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.client.gui.filter.AbstractFilterScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class RegexFilterScreen
extends AbstractFilterScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/regexfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 186;
    private int xPos;
    private int yPos;
    private RegexTextField regexTextField;
    private String errorMsg = "";
    private int errorTimer = 60;
    private final List<String> regexList = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();

    public RegexFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.regexList.addAll(RegexFilter.getRegexList(filterStack));
    }

    public void m_7856_() {
        this.xPos = (this.f_96543_ - 176) / 2;
        this.yPos = (this.f_96544_ - 186) / 2;
        TextFieldManager manager = this.getOrCreateTextFieldManager().clear();
        this.regexTextField = new RegexTextField(this, 1, this.f_96547_, this.xPos + 10, this.yPos + 27, 144, 18);
        this.regexTextField.useGuiTextBackground();
        manager.focus(0);
        if (this.locator.filterSlot >= 0) {
            this.m_142416_((GuiEventListener)new BackButton(this.xPos - 12, this.yPos, p -> this.closeGUI()));
        }
        this.m_142416_((GuiEventListener)new Buttons.AddButton(this.xPos + 155, this.yPos + 23, button -> {
            if (!this.regexTextField.m_94155_().isEmpty()) {
                this.addRegex();
            }
        }));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRemovePosMessage(((Buttons.DeleteButton)button).getId()));
            this.m_142416_((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(TEXTURE_LOCATION, this.xPos, this.yPos, 0, 0, 176, 186);
        graphics.m_280614_(this.f_96547_, this.title, this.xPos + 88 - this.f_96547_.m_92852_((FormattedText)this.title) / 2, this.yPos + 6, 0x404040, false);
        for (int i = 0; i < this.regexList.size(); ++i) {
            String regex = this.regexList.get(i);
            graphics.m_280056_(this.f_96547_, "/" + regex + "/", this.xPos + 28, this.yPos + 55 + i * 19, 0x404080, false);
        }
        if (!this.errorMsg.isEmpty()) {
            graphics.m_280056_(this.f_96547_, this.errorMsg, this.xPos + 8, this.yPos + 170, 0x804040, false);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void m_86600_() {
        if (this.errorTimer > 0 && --this.errorTimer == 0) {
            this.errorMsg = "";
        }
        super.m_86600_();
    }

    private void addRegex() {
        try {
            String regex = this.regexTextField.m_94155_();
            Pattern.compile(regex);
            this.sendAddStringMessage("String", regex);
            this.regexTextField.m_94144_("");
            this.getOrCreateTextFieldManager().focus(0);
            this.errorMsg = "";
        }
        catch (PatternSyntaxException e) {
            this.f_96541_.f_91074_.m_5496_((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
            this.errorMsg = I18n.m_118938_((String)"modularrouters.guiText.label.regexError", (Object[])new Object[0]);
            this.errorTimer = 60;
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.regexList.clear();
        this.regexList.addAll(RegexFilter.getRegexList(stack));
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).f_93624_ = i < this.regexList.size();
        }
    }

    private static class RegexTextField
    extends TextFieldWidgetMR {
        private final RegexFilterScreen parent;

        RegexTextField(RegexFilterScreen parent, int componentId, Font fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(parent.getOrCreateTextFieldManager(), fontrendererObj, x, y, par5Width, par6Height);
            this.parent = parent;
            this.m_94199_(40);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.parent.addRegex();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            if (mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_) && mouseButton == 1) {
                this.m_94144_("");
            }
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
    }
}

