/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ClickCommandLinkMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "click_command_link");
    public ResourceLocation bookId;
    public ResourceLocation commandId;

    public ClickCommandLinkMessage(ResourceLocation bookId, ResourceLocation commandId) {
        this.bookId = bookId;
        this.commandId = commandId;
    }

    public ClickCommandLinkMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.bookId);
        buf.m_130085_(this.commandId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.bookId = buf.m_130281_();
        this.commandId = buf.m_130281_();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        BookCommand command;
        Book book = BookDataManager.get().getBook(this.bookId);
        if (book != null && (command = book.getCommand(this.commandId)) != null) {
            command.execute(player);
        }
    }
}

