/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;

public class ModUtil {
    private static final Set<Class<?>> erroredContexts = new HashSet();
    private static final ClassLoader targetClassLoader = Thread.currentThread().getContextClassLoader();
    public static ForkJoinPool commonPool = new ForkJoinPool(ForkJoinPool.getCommonPoolParallelism(), ModernFixForkJoinWorkerThread::new, null, false);

    private static boolean busListensToEvent(EventBus bus, Class<?> eventClazz) {
        try {
            int busID = (Integer)ObfuscationReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String)"busID");
            return EventListenerHelper.getListenerList(eventClazz).getListeners(busID).length > 0;
        }
        catch (Exception e) {
            ModernFix.LOGGER.error((Object)e);
            return false;
        }
    }

    public static Collection<String> findAllModsListeningToEvent(Class<?> eventClazz) {
        HashSet<String> modsListening = new HashSet<String>();
        ModList.get().forEachModContainer((modId, container) -> {
            Supplier languageExtensionSupplier = (Supplier)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)container, (String)"contextExtension");
            Object context = languageExtensionSupplier.get();
            if (context == null) {
                return;
            }
            if (context instanceof FMLJavaModLoadingContext) {
                if (ModUtil.busListensToEvent((EventBus)((FMLJavaModLoadingContext)context).getModEventBus(), eventClazz)) {
                    modsListening.add((String)modId);
                }
            } else {
                Set<Class<?>> set = erroredContexts;
                synchronized (set) {
                    if (!erroredContexts.contains(context.getClass())) {
                        ModernFix.LOGGER.warn("Unknown modloading context: " + context.getClass().getName());
                        erroredContexts.add(context.getClass());
                    }
                }
            }
        });
        return modsListening;
    }

    private static class ModernFixForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        ModernFixForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
            this.setContextClassLoader(targetClassLoader);
        }
    }
}

