/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.renderer;

import com.direwolf20.laserio.client.screens.CardFluidScreen;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LaserIOItemRendererFluid
extends ItemRenderer {
    private final TextureManager textureManager;
    protected final AbstractContainerScreen screen;

    public LaserIOItemRendererFluid(Minecraft minecraft, TextureManager textureManager, ModelManager modelManager, ItemColors itemColors, BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer, AbstractContainerScreen screen) {
        super(minecraft, textureManager, modelManager, itemColors, blockEntityWithoutLevelRenderer);
        this.textureManager = textureManager;
        this.screen = screen;
    }

    private void fillRect(BufferBuilder p_115153_, int p_115154_, int p_115155_, int p_115156_, int p_115157_, int p_115158_, int p_115159_, int p_115160_, int p_115161_) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        p_115153_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        p_115153_.m_5483_((double)(p_115154_ + 0), (double)(p_115155_ + 0), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + 0), (double)(p_115155_ + p_115157_), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + p_115156_), (double)(p_115155_ + p_115157_), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + p_115156_), (double)(p_115155_ + 0), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)p_115153_.m_231175_());
    }

    public boolean shouldRenderFluid(ItemStack pStack, int pX, int pY, boolean includeCarried, boolean reverseBounds) {
        if (!(this.screen instanceof CardFluidScreen)) {
            return reverseBounds;
        }
        CardFluidScreen cardFluidScreen = (CardFluidScreen)this.screen;
        if (((CardItemContainer)cardFluidScreen.m_6262_()).m_142621_().equals(pStack) && includeCarried) {
            return reverseBounds;
        }
        if (reverseBounds) {
            return !MiscTools.inBounds(cardFluidScreen.filterStartX, cardFluidScreen.filterStartY, cardFluidScreen.filterEndX - cardFluidScreen.filterStartX, cardFluidScreen.filterEndY - cardFluidScreen.filterStartY, pX, pY);
        }
        if (!MiscTools.inBounds(cardFluidScreen.filterStartX, cardFluidScreen.filterStartY, cardFluidScreen.filterEndX - cardFluidScreen.filterStartX, cardFluidScreen.filterEndY - cardFluidScreen.filterStartY, pX, pY)) {
            return reverseBounds;
        }
        LazyOptional fluidHandlerLazyOptional = FluidUtil.getFluidHandler((ItemStack)pStack);
        if (!fluidHandlerLazyOptional.isPresent()) {
            return reverseBounds;
        }
        FluidStack fluidStack = FluidStack.EMPTY;
        IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerLazyOptional.resolve().get();
        for (int tank = 0; tank < fluidHandler.getTanks() && (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty(); ++tank) {
        }
        if (fluidStack.isEmpty()) {
            return reverseBounds;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return reverseBounds;
        }
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        }
        if (fluidStillSprite == null) {
            return reverseBounds;
        }
        return !reverseBounds;
    }

    public void renderFluid(FluidStack fluidStack, int pX, int pY, int size) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        int zLevel = 100;
        float uMin = fluidStillSprite.m_118409_();
        float uMax = fluidStillSprite.m_118410_();
        float vMin = fluidStillSprite.m_118411_();
        float vMax = fluidStillSprite.m_118412_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        vertexBuffer.m_5483_((double)pX, (double)(pY + size), (double)zLevel).m_7421_(uMin, vMax).m_5752_();
        vertexBuffer.m_5483_((double)(pX + size), (double)(pY + size), (double)zLevel).m_7421_(uMax, vMax).m_5752_();
        vertexBuffer.m_5483_((double)(pX + size), (double)pY, (double)zLevel).m_7421_(uMax, vMin).m_5752_();
        vertexBuffer.m_5483_((double)pX, (double)pY, (double)zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
        posestack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

