/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.enderio;

import com.almostreliable.kubeio.enderio.CustomEnergyConduitTicker;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitData;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class CustomEnergyConduitType
extends TieredConduit<EnergyConduitData> {
    private static final ConduitMenuData MENU_DATA = new ConduitMenuData.Simple(false, false, false, false, false, true);
    private final CustomEnergyConduitTicker ticker;

    public CustomEnergyConduitType(ResourceLocation tierName, int transferRate) {
        super(new ResourceLocation("forge:energy"), tierName, transferRate);
        this.ticker = new CustomEnergyConduitTicker(transferRate);
    }

    public ConduitTicker<EnergyConduitData> getTicker() {
        return this.ticker;
    }

    public ConduitMenuData getMenuData() {
        return MENU_DATA;
    }

    public EnergyConduitData createConduitData(Level level, BlockPos pos) {
        return new EnergyConduitData();
    }

    public ConduitType.ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        if (blockEntity == null) {
            return super.getDefaultConnection(level, pos, direction);
        }
        LazyOptional cap = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
        if (cap.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)cap.orElseThrow(() -> new RuntimeException("present capability was not found"));
            if (!storage.canReceive() && !storage.canExtract()) {
                return new ConduitType.ConduitConnectionData(false, true, RedstoneControl.ALWAYS_ACTIVE);
            }
            return new ConduitType.ConduitConnectionData(storage.canReceive(), storage.canExtract(), RedstoneControl.ALWAYS_ACTIVE);
        }
        return super.getDefaultConnection(level, pos, direction);
    }

    public boolean canBeReplacedBy(ConduitType<?> other) {
        return other instanceof EnergyConduitType || super.canBeReplacedBy(other);
    }

    public boolean canBeInSameBlock(ConduitType<?> other) {
        return !(other instanceof EnergyConduitType) && super.canBeInSameBlock(other);
    }
}

