/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TickeableSound
extends AbstractSoundInstance
implements TickableSoundInstance {
    private boolean done;
    private Level world;
    private int distance;
    private float tickIncrease;

    public TickeableSound(Level world, BlockPos pos, SoundEvent soundIn, int distance, int soundTime, RandomSource randomSource) {
        super(soundIn, SoundSource.BLOCKS, randomSource);
        this.world = world;
        this.f_119575_ = pos.m_123341_();
        this.f_119576_ = pos.m_123342_();
        this.f_119577_ = pos.m_123343_();
        this.f_119578_ = false;
        this.done = false;
        this.f_119573_ = 0.8f;
        this.f_119574_ = 0.0f;
        this.f_119582_ = false;
        this.distance = distance;
        this.tickIncrease = 1.0f / ((float)soundTime * 20.0f);
    }

    public boolean m_7801_() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public void increase() {
        if (this.f_119574_ < 2.0f) {
            this.f_119574_ += this.tickIncrease;
        }
    }

    public void decrease() {
        if (this.f_119574_ > 0.0f) {
            this.f_119574_ -= this.tickIncrease;
        }
    }

    public void m_7788_() {
        double distance = Minecraft.m_91087_().f_91074_.m_20183_().m_123333_((Vec3i)new BlockPos((int)this.f_119575_, (int)this.f_119576_, (int)this.f_119577_));
        if (distance > (double)this.distance) {
            this.f_119573_ = 0.0f;
        } else {
            if (distance == 0.0) {
                distance = 1.0;
            }
            this.f_119573_ = (float)(0.8 * (1.0 - distance / (double)this.distance));
        }
    }

    public void setPitch(float pitch) {
        this.f_119574_ = pitch;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

