/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.block.IndustrialBlockItem;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterBlock
extends BasicTileBlock<TransporterTile>
implements SimpleWaterloggedBlock {
    public TransporterBlock() {
        super("transporter", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60910_().m_60978_(2.0f), TransporterTile.class);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, Predicate<TransporterType> filter) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        BlockEntity entity = source.m_7702_(pos);
        if (entity instanceof TransporterTile) {
            for (TransporterType upgrade : ((TransporterTile)entity).getTransporterTypeMap().values()) {
                if (upgrade == null || !filter.test(upgrade)) continue;
                boxes.add(upgrade.getCenterBoundingBox());
                boxes.add(upgrade.getBorderBoundingBox());
            }
        }
        return boxes;
    }

    public BlockEntityType.BlockEntitySupplier<TransporterTile> getTileEntityFactory() {
        return TransporterTile::new;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TransporterType upgrade;
        Pair<Direction, Boolean> upgradePair;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TransporterTile && target instanceof BlockHitResult && (upgradePair = this.getFacingUpgradeHit(state, player.m_9236_(), pos, player)) != null && (upgrade = ((TransporterTile)tileEntity).getTransporterTypeMap().get(upgradePair.getKey())) != null) {
            return new ItemStack((ItemLike)upgrade.getFactory().getUpgradeItem(), 1);
        }
        return ItemStack.f_41583_;
    }

    public Pair<Direction, Boolean> getFacingUpgradeHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null && tileEntity instanceof TransporterTile) {
            for (Direction direction : ((TransporterTile)tileEntity).getTransporterTypeMap().keySet()) {
                if (Shapes.m_83157_((VoxelShape)((TransporterTile)tileEntity).getTransporterTypeMap().get(direction).getCenterBoundingBox(), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) {
                    return Pair.of((Object)direction, (Object)true);
                }
                if (!Shapes.m_83157_((VoxelShape)((TransporterTile)tileEntity).getTransporterTypeMap().get(direction).getBorderBoundingBox(), (VoxelShape)hit, (BooleanOp)BooleanOp.f_82689_)) continue;
                return Pair.of((Object)direction, (Object)false);
            }
        }
        return null;
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return TransporterBlock.getShapes(state, source, pos, conveyorUpgrade -> true);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext p_220053_4_) {
        return TransporterBlock.getShapes(state, world, pos, transporterType -> true).stream().reduce((voxelShape, voxelShape2) -> Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.f_82695_)).orElseGet(Shapes::m_83040_);
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = Shapes.m_83040_();
        for (VoxelShape shape1 : TransporterBlock.getShapes(state, world, pos, conveyorUpgrade -> !conveyorUpgrade.ignoresCollision())) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)shape1, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        Pair<Direction, Boolean> info;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        ItemStack handStack = player.m_21120_(hand);
        if (tileEntity instanceof TransporterTile && (info = this.getFacingUpgradeHit(state, worldIn, pos, player)) != null) {
            Direction facing = (Direction)info.getLeft();
            boolean isMiddle = (Boolean)info.getRight();
            if (player.m_6144_() && handStack.m_41619_()) {
                if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                    ((TransporterTile)tileEntity).removeUpgrade(facing, true);
                    return InteractionResult.SUCCESS;
                }
            } else if (isMiddle) {
                if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                    ((TransporterTile)tileEntity).getTransporterTypeMap().get(facing).toggleAction();
                    return InteractionResult.SUCCESS;
                }
            } else if (((TransporterTile)tileEntity).hasUpgrade(facing)) {
                TransporterType transporterType = ((TransporterTile)tileEntity).getTransporterTypeMap().get(facing);
                if (!handStack.m_41619_() && transporterType.onUpgradeActivated(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                if (transporterType.hasGui()) {
                    ((TransporterTile)tileEntity).openGui(player, facing);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, worldIn, pos, player, hand, ray);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList itemStacks = NonNullList.m_122779_();
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TransporterTile) {
            ((TransporterTile)tileEntity).getTransporterTypeMap().values().forEach(transporterType -> itemStacks.addAll(transporterType.getDrops()));
        }
        return itemStacks;
    }

    public LootTable.Builder getLootTable(@Nonnull BasicBlockLootTables blockLootTables) {
        return blockLootTables.droppingNothing();
    }

    public static class Item
    extends IndustrialBlockItem
    implements ISpecialCreativeTabItem {
        public Item(Block blockIn, TitaniumTab group) {
            super(blockIn, group);
        }

        public void addToTab(BuildCreativeModeTabContentsEvent event) {
        }
    }
}

