/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.blocks;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlock;
import commoble.hyperbox.blocks.HyperboxMenu;
import commoble.hyperbox.dimension.DelayedTeleportData;
import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import commoble.hyperbox.dimension.HyperboxDimension;
import commoble.hyperbox.dimension.HyperboxWorldData;
import commoble.hyperbox.dimension.ReturnPointCapability;
import commoble.hyperbox.dimension.SpawnPointHelper;
import commoble.infiniverse.api.InfiniverseAPI;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class HyperboxBlockEntity
extends BlockEntity
implements Nameable {
    public static final String WORLD_KEY = "world_key";
    public static final String NAME = "CustomName";
    public static final String WEAK_POWER = "weak_power";
    public static final String STRONG_POWER = "strong_power";
    public static final String COLOR = "color";
    private Optional<ResourceKey<Level>> levelKey = Optional.empty();
    private Optional<Component> name = Optional.empty();
    private int color = 4863306;
    private int[] weakPowerDUNSWE = new int[]{0, 0, 0, 0, 0, 0};
    private int[] strongPowerDUNSWE = new int[]{0, 0, 0, 0, 0, 0};

    public static HyperboxBlockEntity create(BlockPos pos, BlockState state) {
        return new HyperboxBlockEntity((BlockEntityType<? extends HyperboxBlockEntity>)((BlockEntityType)Hyperbox.INSTANCE.hyperboxBlockEntityType.get()), pos, state);
    }

    public HyperboxBlockEntity(BlockEntityType<? extends HyperboxBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void updateDimensionAfterPlacingBlock() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Direction[] dirs;
            ServerLevel thisServerLevel = (ServerLevel)level;
            MinecraftServer server = thisServerLevel.m_7654_();
            ServerLevel childLevel = this.getLevelIfKeySet(server);
            if (childLevel == null) {
                return;
            }
            if (((Boolean)Hyperbox.INSTANCE.commonConfig.autoForceHyperboxChunks.get()).booleanValue()) {
                childLevel.m_6325_(HyperboxChunkGenerator.CHUNKPOS.f_45578_, HyperboxChunkGenerator.CHUNKPOS.f_45579_);
                childLevel.m_8602_(HyperboxChunkGenerator.CHUNKPOS.f_45578_, HyperboxChunkGenerator.CHUNKPOS.f_45579_, true);
                childLevel.m_7726_().m_6692_(HyperboxChunkGenerator.CHUNKPOS, true);
            }
            BlockState thisState = this.m_58900_();
            for (Direction dir : dirs = Direction.values()) {
                thisState.onNeighborChange((LevelReader)this.f_58857_, this.f_58858_, this.f_58858_.m_121945_(dir));
            }
            this.f_58857_.m_46717_(this.f_58858_, thisState.m_60734_());
            HyperboxBlock.notifyNeighborsOfStrongSignalChange(thisState, (Level)childLevel, this.f_58858_);
            for (Direction sideOfChildLevel : dirs) {
                this.getAperture(server, sideOfChildLevel).ifPresent(aperture -> {
                    BlockPos aperturePos = aperture.m_58899_();
                    aperture.m_58900_().onNeighborChange((LevelReader)aperture.m_58904_(), aperturePos, aperturePos.m_121945_(sideOfChildLevel.m_122424_()));
                });
            }
        }
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.m_6596_();
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            this.f_58857_.m_6550_(this.f_58858_, state, state);
        }
    }

    public int getColor() {
        return this.color;
    }

    public Optional<ResourceKey<Level>> getLevelKey() {
        return this.levelKey;
    }

    public void setLevelKey(ResourceKey<Level> key) {
        this.levelKey = Optional.ofNullable(key);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.getLevelIfKeySet(level2.m_7654_());
        }
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.name.orElse((Component)Component.m_237115_((String)"block.hyperbox.hyperbox"));
    }

    @Nullable
    public Component m_7770_() {
        return this.name.orElse(null);
    }

    public void setName(@Nullable Component name) {
        this.name = Optional.ofNullable(name);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public ServerLevel getLevelIfKeySet(MinecraftServer server) {
        return this.levelKey.map(key -> {
            ServerLevel targetWorld = this.getChildWorld(server, (ResourceKey<Level>)key);
            HyperboxWorldData.getOrCreate(targetWorld).setWorldPos(server, targetWorld, (ResourceKey<Level>)targetWorld.m_46472_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_, this.getColor());
            return targetWorld;
        }).orElse(null);
    }

    public ServerLevel getChildWorld(MinecraftServer server, ResourceKey<Level> key) {
        return InfiniverseAPI.get().getOrCreateLevel(server, key, () -> HyperboxDimension.createDimension(server));
    }

    public int getPower(boolean strong, Direction originalFace) {
        int output = (strong ? this.strongPowerDUNSWE : this.weakPowerDUNSWE)[originalFace.m_122411_()] - 1;
        return Mth.m_14045_((int)output, (int)0, (int)15);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction worldSpaceFace) {
        BlockState thisState;
        Block thisBlock;
        if (worldSpaceFace != null && (thisBlock = (thisState = this.m_58900_()).m_60734_()) instanceof HyperboxBlock) {
            BlockPos targetPos;
            BlockEntity delegateBlockEntity;
            ServerLevel serverLevel;
            ServerLevel targetLevel;
            HyperboxBlock hyperboxBlock = (HyperboxBlock)thisBlock;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel && (targetLevel = this.getLevelIfKeySet((serverLevel = (ServerLevel)level).m_7654_())) != null && (delegateBlockEntity = targetLevel.m_7702_(targetPos = hyperboxBlock.getPosAdjacentToAperture(this.m_58900_(), worldSpaceFace))) != null) {
                Direction rotatedDirection = hyperboxBlock.getOriginalFace(thisState, worldSpaceFace);
                return delegateBlockEntity.getCapability(cap, rotatedDirection);
            }
        }
        return super.getCapability(cap, worldSpaceFace);
    }

    public Optional<ApertureBlockEntity> getAperture(MinecraftServer server, Direction sideOfChildLevel) {
        Optional<ApertureBlockEntity> optional;
        BlockPos aperturePos = HyperboxChunkGenerator.CENTER.m_5484_(sideOfChildLevel, 7);
        ServerLevel targetLevel = this.getLevelIfKeySet(server);
        if (targetLevel == null) {
            optional = Optional.empty();
        } else {
            BlockEntity blockEntity = targetLevel.m_7702_(aperturePos);
            if (blockEntity instanceof ApertureBlockEntity) {
                ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
                optional = Optional.of(aperture);
            } else {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    public void updatePower(int weakPower, int strongPower, Direction originalFace) {
        BlockState thisState = this.m_58900_();
        Block thisBlock = thisState.m_60734_();
        if (thisBlock instanceof HyperboxBlock) {
            HyperboxBlock hyperboxBlock = (HyperboxBlock)thisBlock;
            Direction worldSpaceFace = hyperboxBlock.getCurrentFacing(thisState, originalFace);
            int originalFaceIndex = originalFace.m_122411_();
            int oldWeakPower = this.weakPowerDUNSWE[originalFaceIndex];
            int oldStrongPower = this.strongPowerDUNSWE[originalFaceIndex];
            if (oldWeakPower != weakPower || oldStrongPower != strongPower) {
                this.weakPowerDUNSWE[originalFaceIndex] = weakPower;
                this.strongPowerDUNSWE[originalFaceIndex] = strongPower;
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, thisState, thisState, 3);
                if (ForgeEventFactory.onNeighborNotify((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)thisState, EnumSet.of(originalFace), (boolean)true).isCanceled()) {
                    return;
                }
                BlockPos adjacentPos = this.f_58858_.m_121945_(worldSpaceFace);
                this.f_58857_.m_46586_(adjacentPos, thisBlock, this.f_58858_);
                this.f_58857_.m_46590_(adjacentPos, thisBlock, worldSpaceFace.m_122424_());
            }
        }
    }

    public void teleportPlayerOrOpenMenu(ServerPlayer serverPlayer, Direction faceActivated) {
        ServerLevel level = serverPlayer.m_284548_();
        MinecraftServer server = level.m_7654_();
        ServerLevel targetLevel = this.getLevelIfKeySet(server);
        if (targetLevel == null) {
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)HyperboxMenu.makeServerMenu(this));
        } else {
            BlockPos pos = this.m_58899_();
            BlockState state = this.m_58900_();
            DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
            if (hyperboxDimensionType != level.m_6042_()) {
                serverPlayer.getCapability(ReturnPointCapability.INSTANCE).ifPresent(cap -> cap.setReturnPoint((ResourceKey<Level>)level.m_46472_(), pos));
            }
            BlockPos posAdjacentToAperture = ((HyperboxBlock)state.m_60734_()).getPosAdjacentToAperture(state, faceActivated);
            BlockPos spawnPoint = SpawnPointHelper.getBestSpawnPosition((BlockGetter)targetLevel, posAdjacentToAperture, HyperboxChunkGenerator.MIN_SPAWN_CORNER, HyperboxChunkGenerator.MAX_SPAWN_CORNER);
            DelayedTeleportData.getOrCreate(serverPlayer.m_284548_()).schedulePlayerTeleport((Player)serverPlayer, (ResourceKey<Level>)targetLevel.m_46472_(), Vec3.m_82512_((Vec3i)spawnPoint));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.levelKey.ifPresent(key -> compound.m_128359_(WORLD_KEY, key.m_135782_().toString()));
        this.writeClientSensitiveData(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.levelKey = nbt.m_128441_(WORLD_KEY) ? Optional.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_(WORLD_KEY)))) : Optional.empty();
        this.readClientSensitiveData(nbt);
    }

    protected CompoundTag writeClientSensitiveData(CompoundTag nbt) {
        this.name.ifPresent(theName -> nbt.m_128359_(NAME, Component.Serializer.m_130703_((Component)theName)));
        if (this.color != 4863306) {
            nbt.m_128405_(COLOR, this.color);
        }
        nbt.m_128385_(WEAK_POWER, this.weakPowerDUNSWE);
        nbt.m_128385_(STRONG_POWER, this.strongPowerDUNSWE);
        return nbt;
    }

    protected void readClientSensitiveData(CompoundTag nbt) {
        this.name = nbt.m_128441_(NAME) ? Optional.ofNullable(Component.Serializer.m_130701_((String)nbt.m_128461_(NAME))) : Optional.empty();
        this.color = nbt.m_128441_(COLOR) ? nbt.m_128451_(COLOR) : 4863306;
        this.weakPowerDUNSWE = nbt.m_128465_(WEAK_POWER);
        this.strongPowerDUNSWE = nbt.m_128465_(STRONG_POWER);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeClientSensitiveData(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readClientSensitiveData(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.readClientSensitiveData(nbt);
    }
}

