/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.predicate;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MatchStateConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchStateConnectionPredicate> SERIALIZER = new Serializer<MatchStateConnectionPredicate>(){

        @Override
        public MatchStateConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match state predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            if (!BuiltInRegistries.f_256975_.m_7804_(identifier)) {
                throw new JsonParseException("Unknown block '" + identifier + "'!");
            }
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(identifier);
            ArrayList<Pair<Property<?>, Set<?>>> properties = new ArrayList();
            if (!json.has("properties") || !json.get("properties").isJsonObject()) {
                throw new JsonParseException("Match block predicate must have string property 'block'!");
            }
            for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
                Property property = block.m_49965_().m_61081_((String)entry.getKey());
                if (property == null) {
                    throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    Optional value = property.m_6215_(((JsonElement)entry.getValue()).getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.m_61708_() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                        }
                        Optional value = property.m_6215_(element.getAsString());
                        if (value.isEmpty()) {
                            throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.m_61708_() + "' in block '" + identifier + "'!");
                        }
                        builder.add(value.get());
                    }
                } else {
                    throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                }
                properties.add(Pair.of(property, builder.build()));
            }
            properties = Arrays.asList((Pair[])properties.toArray(Pair[]::new));
            return new MatchStateConnectionPredicate(block, properties);
        }

        @Override
        public JsonObject serialize(MatchStateConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)value.block).toString());
            JsonObject properties = new JsonObject();
            value.properties.stream().map(p -> p.mapRight(values -> {
                JsonArray array = new JsonArray(values.size());
                values.stream().map(v -> ((Property)p.left()).m_6940_((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            })).map(p -> p.mapLeft(Property::m_61708_)).sorted(Comparator.comparing(Pair::left)).forEach(pair -> properties.add((String)pair.left(), (JsonElement)pair.right()));
            json.add("properties", (JsonElement)properties);
            return json;
        }
    };
    private final Block block;
    private final List<Pair<Property<?>, Set<?>>> properties;
    private boolean compareStates = false;
    private Set<BlockState> states = null;

    public MatchStateConnectionPredicate(Block block, List<Pair<Property<?>, Set<?>>> properties) {
        this.block = block;
        this.properties = properties;
        this.computeStates();
    }

    @SafeVarargs
    public MatchStateConnectionPredicate(Block block, Pair<Property<?>, ?> ... propertyPair) {
        this.block = block;
        HashMap<Property, List> propertyMap = new HashMap<Property, List>();
        for (Pair<Property<?>, ?> pair : propertyPair) {
            Property<?> property = pair.left();
            if (!block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property.m_61708_() + "' is not a property of block '" + BuiltInRegistries.f_256975_.m_7981_((Object)block) + "'!");
            }
            Object value = pair.right();
            if (!property.m_6908_().contains(value)) {
                throw new IllegalArgumentException("Invalid value '" + value + "' for property '" + property.m_61708_() + "'!");
            }
            propertyMap.computeIfAbsent(property, p -> new ArrayList()).add(value);
        }
        Pair[] properties = new Pair[propertyMap.size()];
        int index = 0;
        for (Map.Entry entry : propertyMap.entrySet()) {
            properties[index++] = Pair.of((Property)entry.getKey(), ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.properties = Arrays.asList(properties);
        this.computeStates();
    }

    private <T extends Comparable<T>> void computeStates() {
        int validStates = 1;
        for (Pair<Property<?>, Set<?>> pair : this.properties) {
            validStates *= pair.right().size();
        }
        if (validStates > 64) {
            return;
        }
        Collection<Object> states = Collections.singleton((BlockState)this.block.m_49965_().m_61090_());
        for (Pair<Property<?>, Set<?>> pair : this.properties) {
            Property<?> property = pair.left();
            Set<?> values = pair.right();
            states = states.stream().flatMap(state -> values.stream().map(value -> (BlockState)state.m_61124_(property, (Comparable)value))).collect(Collectors.toUnmodifiableList());
        }
        this.compareStates = true;
        this.states = ImmutableSet.copyOf(states);
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        if (this.compareStates) {
            return this.states.contains(otherState);
        }
        if (otherState.m_60734_() != this.block) {
            return false;
        }
        for (Pair<Property<?>, Set<?>> property : this.properties) {
            if (property.right().contains(otherState.m_61143_(property.left()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }
}

