/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public abstract class ItemControllableDrawerTile<T extends ItemControllableDrawerTile<T>>
extends ControllableDrawerTile<T> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    private int removeTicks = 0;

    public ItemControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.removeTicks = Math.max(this.removeTicks - 1, 0);
        if (level.m_46467_() % (long)FunctionalStorageConfig.UPGRADE_TICK == 0L && this.getUtilitySlotAmount() > 0) {
            block0: for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                Direction direction;
                ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item.equals(FunctionalStorage.PULLING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_121945_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(iItemHandler -> {
                        for (int otherSlot = 0; otherSlot < iItemHandler.getSlots(); ++otherSlot) {
                            ItemStack pulledStack = iItemHandler.extractItem(otherSlot, FunctionalStorageConfig.UPGRADE_PULL_ITEMS, true);
                            if (pulledStack.m_41619_()) continue;
                            boolean hasWorked = false;
                            for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                                ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack, true);
                                if (simulated.equals(pulledStack)) continue;
                                ItemStack extracted = iItemHandler.extractItem(otherSlot, pulledStack.m_41613_() - simulated.m_41613_(), false);
                                this.getStorage().insertItem(ourSlot, extracted, false);
                                hasWorked = true;
                                break;
                            }
                            if (hasWorked) break;
                        }
                    }));
                }
                if (item.equals(FunctionalStorage.PUSHING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_121945_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(otherHandler -> {
                        for (int drawerSlot = 0; drawerSlot < this.getStorage().getSlots(); ++drawerSlot) {
                            ItemStack pulledStack = this.getStorage().extractItem(drawerSlot, FunctionalStorageConfig.UPGRADE_PUSH_ITEMS, true);
                            if (pulledStack.m_41619_()) continue;
                            boolean hasWorked = false;
                            for (int destinationSlot = 0; destinationSlot < otherHandler.getSlots(); ++destinationSlot) {
                                ItemStack simulated;
                                ItemStack otherHandlerStackInSlot = otherHandler.getStackInSlot(destinationSlot);
                                if (!otherHandlerStackInSlot.m_41619_() && !ItemStack.m_150942_((ItemStack)pulledStack, (ItemStack)otherHandler.getStackInSlot(destinationSlot)) || otherHandler.getStackInSlot(destinationSlot).m_41613_() >= otherHandler.getSlotLimit(destinationSlot) || (simulated = otherHandler.insertItem(destinationSlot, pulledStack, true)).m_41613_() > pulledStack.m_41613_()) continue;
                                otherHandler.insertItem(destinationSlot, this.getStorage().extractItem(drawerSlot, pulledStack.m_41613_() - simulated.m_41613_(), false), false);
                                hasWorked = true;
                                break;
                            }
                            if (hasWorked) break;
                        }
                    }));
                }
                if (!item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) continue;
                direction = UpgradeItem.getDirection(stack);
                AABB box = new AABB(pos.m_121945_(direction));
                for (ItemEntity entitiesOfClass : level.m_45976_(ItemEntity.class, box)) {
                    ItemStack pulledStack = ItemHandlerHelper.copyStackWithSize((ItemStack)entitiesOfClass.m_32055_(), (int)Math.min(entitiesOfClass.m_32055_().m_41613_(), FunctionalStorageConfig.UPGRADE_COLLECTOR_ITEMS));
                    if (pulledStack.m_41619_()) continue;
                    boolean hasWorked = false;
                    for (int ourSlot = 0; ourSlot < this.getStorage().getSlots(); ++ourSlot) {
                        ItemStack simulated = this.getStorage().insertItem(ourSlot, pulledStack, true);
                        if (simulated.m_41613_() == pulledStack.m_41613_()) continue;
                        this.getStorage().insertItem(ourSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)entitiesOfClass.m_32055_(), (int)(pulledStack.m_41613_() - simulated.m_41613_())), false);
                        entitiesOfClass.m_32055_().m_41774_(pulledStack.m_41613_() - simulated.m_41613_());
                        hasWorked = true;
                        break;
                    }
                    if (!hasWorked) continue;
                    continue block0;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot != -1 && this.isServer()) {
            if (!stack.m_41619_() && this.getStorage().insertItem(slot, stack, true).m_41613_() != stack.m_41613_()) {
                playerIn.m_21008_(hand, this.getStorage().insertItem(slot, stack, false));
                return InteractionResult.SUCCESS;
            }
            if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.m_20148_(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.m_150109_().f_35974_) {
                    if (itemStack.m_41619_() || this.getStorage().insertItem(slot, itemStack, true).m_41613_() == itemStack.m_41613_()) continue;
                    itemStack.m_41764_(this.getStorage().insertItem(slot, itemStack.m_41777_(), false).m_41613_());
                }
            }
            INTERACTION_LOGGER.put(playerIn.m_20148_(), System.currentTimeMillis());
        }
        if (super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public abstract int getStorageSlotAmount();

    @Override
    public void onClicked(Player playerIn, int slot) {
        if (this.isServer() && slot != -1 && this.removeTicks == 0) {
            BlockHitResult blockResult;
            Direction facing;
            this.removeTicks = 3;
            HitResult rayTraceResult = RayTraceUtils.rayTraceSimple((Level)this.f_58857_, (LivingEntity)playerIn, (double)16.0, (float)0.0f);
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && (facing = (blockResult = (BlockHitResult)rayTraceResult).m_82434_()).equals((Object)this.getFacingDirection())) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.getStorage().extractItem(slot, playerIn.m_6144_() ? this.getStorage().getStackInSlot(slot).m_41741_() : 1, false));
            }
        }
    }

    public abstract IItemHandler getStorage();

    public abstract LazyOptional<IItemHandler> getOptional();

    @Override
    public abstract int getBaseSize(int var1);

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.getOptional().invalidate();
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<T>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.m_41720_() instanceof StorageUpgradeItem) {
                    int i;
                    int mult = 1;
                    for (i = 0; i < ItemControllableDrawerTile.this.getStorageUpgrades().getSlots(); ++i) {
                        if (!(ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).m_41720_() instanceof StorageUpgradeItem) || i == slot) continue;
                        if (mult == 1) {
                            mult = ((StorageUpgradeItem)ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).m_41720_()).getStorageMultiplier();
                            continue;
                        }
                        mult *= ((StorageUpgradeItem)ItemControllableDrawerTile.this.getStorageUpgrades().getStackInSlot(i).m_41720_()).getStorageMultiplier();
                    }
                    for (i = 0; i < ItemControllableDrawerTile.this.getStorage().getSlots(); ++i) {
                        if (ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).m_41619_()) continue;
                        double stackSize = (double)ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).m_41741_() / 64.0;
                        if ((int)Math.floor((double)Math.min(Integer.MAX_VALUE, (long)ItemControllableDrawerTile.this.getBaseSize(i) * (long)mult) * stackSize) >= ItemControllableDrawerTile.this.getStorage().getStackInSlot(i).m_41613_()) continue;
                        return ItemStack.f_41583_;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (stack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                for (int i = 0; i < this.getStorage().getSlots(); ++i) {
                    if (this.getStorage().getStackInSlot(i).m_41613_() <= 64) continue;
                    return false;
                }
            }
            return stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> this.setNeedsUpgradeCache(true)).setSlotLimit(1);
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTitleColor() {
        return ChatFormatting.DARK_GRAY.m_126665_();
    }
}

