/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import com.google.common.collect.Sets;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ChunkChangeResponsePacket;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.util.EnumMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class RequestChunkChangePacket
extends BaseC2SMessage {
    private final ChunkChangeOp action;
    private final Set<XZ> chunks;

    public RequestChunkChangePacket(ChunkChangeOp action, Set<XZ> chunks) {
        this.action = action;
        this.chunks = chunks;
    }

    RequestChunkChangePacket(FriendlyByteBuf buf) {
        this.action = (ChunkChangeOp)buf.m_130066_(ChunkChangeOp.class);
        this.chunks = (Set)buf.m_236838_(Sets::newHashSetWithExpectedSize, buf1 -> XZ.of((int)buf1.m_130242_(), (int)buf1.m_130242_()));
    }

    public MessageType getType() {
        return FTBChunksNet.REQUEST_CHUNK_CHANGE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
        buf.m_236828_(this.chunks, (buf1, xz) -> {
            buf1.m_130130_(xz.x());
            buf1.m_130130_(xz.z());
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        CommandSourceStack source = player.m_20203_();
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        Function<XZ, ClaimResult> consumer = switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case ChunkChangeOp.CLAIM -> pos -> data.claim(source, pos.dim(player.m_9236_()), false);
            case ChunkChangeOp.UNCLAIM -> pos -> data.unclaim(source, pos.dim(player.m_9236_()), false);
            case ChunkChangeOp.LOAD -> pos -> data.forceLoad(source, pos.dim(player.m_9236_()), false);
            case ChunkChangeOp.UNLOAD -> pos -> data.unForceLoad(source, pos.dim(player.m_9236_()), false);
        };
        EnumMap<ClaimResult.StandardProblem, Integer> problems = new EnumMap<ClaimResult.StandardProblem, Integer>(ClaimResult.StandardProblem.class);
        int changed = 0;
        for (XZ pos2 : this.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (!r.isSuccess()) {
                FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.m_6302_(), this.action.name, player.m_9236_().m_46472_().m_135782_(), pos2.x(), pos2.z(), r));
                if (!(r instanceof ClaimResult.StandardProblem)) continue;
                ClaimResult.StandardProblem cr = (ClaimResult.StandardProblem)r;
                problems.put(cr, problems.getOrDefault(cr, 0) + 1);
                continue;
            }
            ++changed;
        }
        new ChunkChangeResponsePacket(this.chunks.size(), changed, problems).sendTo(player);
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
    }

    public static enum ChunkChangeOp {
        CLAIM("claim"),
        UNCLAIM("unclaim"),
        LOAD("load"),
        UNLOAD("unload");

        private final String name;

        private ChunkChangeOp(String name) {
            this.name = name;
        }

        public static ChunkChangeOp create(boolean isLeftMouse, boolean isShift) {
            return isShift ? (isLeftMouse ? LOAD : UNLOAD) : (isLeftMouse ? CLAIM : UNCLAIM);
        }
    }
}

