/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.world.feature;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.world.feature.ForceFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ForceFeatureKeys {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FORCE = FeatureUtils.m_255087_((String)"forcecraft:ore_force");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FORCE_BURIED = FeatureUtils.m_255087_((String)"forcecraft:ore_force_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FORCE_TREE = FeatureUtils.m_255087_((String)"forcecraft:force_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG = FeatureUtils.m_255087_((String)"forcecraft:force_tree_with_bees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_FORCE = FeatureUtils.m_255087_((String)"forcecraft:trees_force");
    public static final ResourceKey<PlacedFeature> PLACED_ORE_FORCE = PlacementUtils.m_255070_((String)"forcecraft:ore_force");
    public static final ResourceKey<PlacedFeature> PLACED_ORE_FORCE_BURIED = PlacementUtils.m_255070_((String)"forcecraft:ore_force_buried");
    public static final ResourceKey<PlacedFeature> PLACED_FORCE_TREE = PlacementUtils.m_255070_((String)"forcecraft:force_tree");
    public static final ResourceKey<PlacedFeature> PLACED_FORCE_TREE_BEES_002 = PlacementUtils.m_255070_((String)"forcecraft:force_tree_bees_002");

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(BlockState trunkState, BlockState foliageState, int baseHeight, int heightRandA, int heightRandB, int p_195152_) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)trunkState), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)foliageState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)p_195152_), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createForceTree() {
        return ForceFeatureKeys.createStraightBlobTree(((Block)ForceRegistry.FORCE_LOG.get()).m_49966_(), ((Block)ForceRegistry.FORCE_LEAVES.get()).m_49966_(), 4, 2, 0, 2).m_68244_();
    }

    public static void configuredBootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneRuleTest = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateRuleTest = new TagMatchTest(BlockTags.f_144267_);
        List<OreConfiguration.TargetBlockState> list = List.of(OreConfiguration.m_161021_((RuleTest)stoneRuleTest, (BlockState)((Block)ForceRegistry.POWER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateRuleTest, (BlockState)((Block)ForceRegistry.DEEPSLATE_POWER_ORE.get()).m_49966_()));
        HolderGetter placedFeatureHolderGetter = context.m_255420_(Registries.f_256988_);
        Holder.Reference PLACED_FORCE_TREE_BEES = placedFeatureHolderGetter.m_255043_(PLACED_FORCE_TREE_BEES_002);
        Holder.Reference PLACED_FORCE_TREE = placedFeatureHolderGetter.m_255043_(ForceFeatureKeys.PLACED_FORCE_TREE);
        FeatureUtils.m_254977_(context, ORE_FORCE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(list, 6));
        FeatureUtils.m_254977_(context, ORE_FORCE_BURIED, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(list, 6, 1.0f));
        BeehiveDecorator decorator_005 = new BeehiveDecorator(0.05f);
        FeatureUtils.m_254977_(context, FORCE_TREE, (Feature)((Feature)ForceFeatures.FORCE_TREE.get()), (FeatureConfiguration)ForceFeatureKeys.createForceTree().m_68251_());
        FeatureUtils.m_254977_(context, FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG, (Feature)((Feature)ForceFeatures.FORCE_TREE.get()), (FeatureConfiguration)ForceFeatureKeys.createForceTree().m_68249_(List.of(decorator_005)).m_68251_());
        FeatureUtils.m_254977_(context, TREES_FORCE, (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)PLACED_FORCE_TREE_BEES, 0.2f)), (Holder)PLACED_FORCE_TREE));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier1, PlacementModifier modifier2) {
        return List.of(modifier1, InSquarePlacement.m_191715_(), modifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ForceFeatureKeys.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
    }

    public static void placedBootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.m_255420_(Registries.f_256911_);
        PlacementUtils.m_254943_(context, PLACED_ORE_FORCE, (Holder)holdergetter.m_255043_(ORE_FORCE), ForceFeatureKeys.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)48))));
        PlacementUtils.m_254943_(context, PLACED_ORE_FORCE_BURIED, (Holder)holdergetter.m_255043_(ORE_FORCE_BURIED), ForceFeatureKeys.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        PlacementUtils.m_254943_(context, PLACED_FORCE_TREE, (Holder)holdergetter.m_255043_(FORCE_TREE), (List)VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
        PlacementUtils.m_254943_(context, PLACED_FORCE_TREE_BEES_002, (Holder)holdergetter.m_255043_(FORCE_TREE_WITH_MORE_BEEHIVES_CONFIG), (List)VegetationPlacements.m_195481_((PlacementModifier)RarityFilter.m_191900_((int)3), (Block)((Block)ForceRegistry.FORCE_SAPLING.get())));
    }
}

