/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.util;

import com.mrbysco.forcecraft.blocks.ForceLogBlock;
import com.mrbysco.forcecraft.networking.PacketHandler;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ForceUtils {
    public static boolean teleportToLocation(Player player, double x, double y, double z, boolean broadcast) {
        Level level = player.m_9236_();
        player.m_6021_(x, y, z);
        if (broadcast) {
            level.m_7605_((Entity)player, (byte)46);
        }
        return true;
    }

    public static void removeEnchant(Enchantment enchantment, ItemStack stack) {
        Map enchantMap = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantMap.containsKey(enchantment)) {
            enchantMap.remove(enchantment);
        }
        EnchantmentHelper.m_44865_((Map)enchantMap, (ItemStack)stack);
    }

    public static boolean isTree(Level level, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.m_123342_() <= pos.m_123342_() || !ForceUtils.isLog(level, candidate)) continue;
            pos = candidate.m_7494_();
            while (ForceUtils.isLog(level, pos)) {
                pos = pos.m_7494_();
            }
            candidates.add(pos.m_122012_());
            candidates.add(pos.m_122029_());
            candidates.add(pos.m_122019_());
            candidates.add(pos.m_122024_());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.m_7918_(o + x, o + y, o + z);
                    BlockState state = level.m_8055_(leaf);
                    if (!state.m_204336_(BlockTags.f_13035_) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLog(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13106_) || level.m_8055_(pos).m_60734_() instanceof ForceLogBlock;
    }

    public static void breakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos, BlockPos refPos) {
        if (!ForceUtils.canBreakExtraBlock(stack, level, player, pos, refPos)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        Block block = state.m_60734_();
        stack.m_41686_(level, state, pos, player);
        if (!level.f_46443_) {
            int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            BlockEntity tileEntity = level.m_7702_(pos);
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.m_5707_(level, pos, state, player);
                block.m_6240_(level, player, pos, state, tileEntity, stack);
                block.m_49805_((ServerLevel)level, pos, xp);
            }
            PacketHandler.sendPacket((Entity)player, new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
        } else {
            level.m_6798_(2001, pos, Block.m_49956_((BlockState)state));
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.m_5707_(level, pos, state, player);
            }
            stack.m_41686_(level, state, pos, player);
            if (stack.m_41613_() == 0 && stack == player.m_21205_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            ClientPacketListener netHandlerPlayClient = Minecraft.m_91087_().m_91403_();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, Direction.DOWN));
        }
    }

    private static boolean canBreakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos, BlockPos refPos) {
        if (level.m_46859_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        Block block = state.m_60734_();
        BlockState refState = level.m_8055_(refPos);
        float refStrength = refState.m_60625_(player, (BlockGetter)level, refPos);
        float strength = state.m_60625_(player, (BlockGetter)level, pos);
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.m_150110_().f_35937_) {
            block.m_5707_(level, pos, state, player);
            if (block.onDestroyedByPlayer(state, level, pos, player, false, fluidState)) {
                block.m_5707_(level, pos, state, player);
            }
            if (!level.f_46443_) {
                PacketHandler.sendPacket((Entity)player, new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
            return false;
        }
        return true;
    }

    public static boolean isFakePlayer(Entity player) {
        return player instanceof FakePlayer;
    }

    public static String resource(String res) {
        return String.format("%s:%s", "forcecraft", res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation("forcecraft", res);
    }

    public static void teleportRandomly(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_() && !livingEntity.m_20072_()) {
            double d0 = livingEntity.m_20185_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 32.0;
            double d1 = livingEntity.m_20186_() + (double)(livingEntity.m_217043_().m_188503_(32) - 16);
            double d2 = livingEntity.m_20189_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 32.0;
            ForceUtils.teleportTo(livingEntity, d0, d1, d2);
        }
    }

    public static void teleportTo(LivingEntity living, double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutable.m_123342_() > 0 && !living.m_9236_().m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = living.m_9236_().m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(living, x, y, z);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            boolean flag2 = living.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !living.m_20067_()) {
                living.m_9236_().m_6263_((Player)null, living.f_19854_, living.f_19855_, living.f_19856_, SoundEvents.f_11852_, living.m_5720_(), 1.0f, 1.0f);
                living.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }
}

