/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.registry;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ForceFluids {
    private static final ResourceLocation STILL_METAL = new ResourceLocation("forcecraft", "block/force_fluid_source");
    private static final ResourceLocation FLOWING_METAL = new ResourceLocation("forcecraft", "block/force_fluid_flowing");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"forcecraft");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"forcecraft");
    private static RegistryObject<FluidType> FORCE_TYPE = FLUID_TYPES.register("force", () -> new FluidType(ForceFluids.createTypeProperties()){

        public double motionScale(Entity entity) {
            return entity.m_9236_().m_6042_().f_63857_() ? 0.007 : 0.0023333333333333335;
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return STILL_METAL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOWING_METAL;
                }

                public int getTintColor() {
                    return -1;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                }
            });
        }
    });
    public static RegistryObject<FlowingFluid> FORCE_FLUID_SOURCE;
    public static RegistryObject<FlowingFluid> FORCE_FLUID_FLOWING;
    public static ForgeFlowingFluid.Properties FLUID_FORCE_PROPERTIES;

    public static void registerFluids() {
        FORCE_FLUID_SOURCE = FLUIDS.register("fluid_force_source", () -> new ForgeFlowingFluid.Source(FLUID_FORCE_PROPERTIES));
        FORCE_FLUID_FLOWING = FLUIDS.register("fluid_force_flowing", () -> new ForgeFlowingFluid.Flowing(FLUID_FORCE_PROPERTIES));
    }

    public static FluidType.Properties createTypeProperties() {
        return FluidType.Properties.create().canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).rarity(Rarity.COMMON).lightLevel(0).density(2000).viscosity(1000).temperature(120);
    }

    static {
        FLUID_FORCE_PROPERTIES = new ForgeFlowingFluid.Properties(() -> (FluidType)FORCE_TYPE.get(), () -> (Fluid)FORCE_FLUID_SOURCE.get(), () -> (Fluid)FORCE_FLUID_FLOWING.get()).bucket(ForceRegistry.BUCKET_FLUID_FORCE).block(() -> (LiquidBlock)ForceRegistry.FORCE_FLUID_BLOCK.get());
    }
}

