/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessNoRemainderRecipe
extends ShapelessRecipe {
    private final ResourceLocation id;
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public ShapelessNoRemainderRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id, group, category, result, ingredients);
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ForceRecipeSerializers.SHAPELESS_NO_REMAINDER_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        return nonnulllist;
    }

    public static class SerializerShapelessNoRemainderRecipe
    implements RecipeSerializer<ShapelessNoRemainderRecipe> {
        public ShapelessNoRemainderRecipe fromJson(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)p_44291_, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = SerializerShapelessNoRemainderRecipe.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new ShapelessNoRemainderRecipe(p_44290_, s, craftingbookcategory, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)p_44276_.get(i), (boolean)false);
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ShapelessNoRemainderRecipe fromNetwork(ResourceLocation p_44293_, FriendlyByteBuf p_44294_) {
            String s = p_44294_.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_44294_.m_130066_(CraftingBookCategory.class);
            int i = p_44294_.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44294_));
            }
            ItemStack itemstack = p_44294_.m_130267_();
            return new ShapelessNoRemainderRecipe(p_44293_, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf p_44281_, ShapelessNoRemainderRecipe p_44282_) {
            p_44281_.m_130070_(p_44282_.group);
            p_44281_.m_130068_((Enum)p_44282_.category);
            p_44281_.m_130130_(p_44282_.ingredients.size());
            for (Ingredient ingredient : p_44282_.ingredients) {
                ingredient.m_43923_(p_44281_);
            }
            p_44281_.m_130055_(p_44282_.result);
        }
    }
}

