/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.blockentities.InfuserModifierType;
import com.mrbysco.forcecraft.capabilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class InfuseRecipe
implements Recipe<InfuserBlockEntity> {
    private static final int MAX_SLOTS = 8;
    private static final Set<String> HASHES = new HashSet<String>();
    public static final Map<Integer, List<InfuseRecipe>> RECIPESBYLEVEL = new HashMap<Integer, List<InfuseRecipe>>();
    private final ResourceLocation id;
    public Ingredient input = Ingredient.f_43901_;
    public InfuserModifierType resultModifier;
    ItemStack output = ItemStack.f_41583_;
    private UpgradeBookTier tier;
    private Ingredient center;
    private int time;

    public InfuseRecipe(ResourceLocation id, Ingredient center, Ingredient input, InfuserModifierType result, UpgradeBookTier tier, ItemStack outputStack) {
        this.id = id;
        this.input = input;
        this.center = center;
        this.output = outputStack;
        this.resultModifier = result;
        this.setTier(tier);
    }

    public boolean m_5598_() {
        return true;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean matches(InfuserBlockEntity inv, Level level) {
        for (int i = 0; i < inv.handler.getSlots(); ++i) {
            ItemStack stack = inv.handler.getStackInSlot(i);
            if (i >= 8) continue;
            return this.matchesModifier(inv, stack, false);
        }
        return false;
    }

    public boolean matchesModifier(InfuserBlockEntity inv, ItemStack modifier, boolean ignoreInfused) {
        UpgradeBookData bd = new UpgradeBookData(inv.getBookInSlot());
        int bookTier = bd.getTier().ordinal();
        if (this.getTier().ordinal() > bookTier) {
            return false;
        }
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        boolean toolMatches = this.matchesTool(centerStack, ignoreInfused);
        boolean modifierMatches = this.matchesModifier(centerStack, modifier);
        return toolMatches && modifierMatches;
    }

    public boolean matchesModifier(InfuserBlockEntity inv, ItemStack modifierStack) {
        ItemStack centerStack = inv.handler.getStackInSlot(8);
        return this.matchesModifier(centerStack, modifierStack);
    }

    public boolean matchesModifier(ItemStack centerStack, ItemStack modifierStack) {
        IItemHandler handler;
        if (modifierStack.m_41720_() == ForceRegistry.FORCE_PACK_UPGRADE.get() && (handler = (IItemHandler)centerStack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) instanceof PackItemStackHandler && ((PackItemStackHandler)handler).getUpgrades() != this.getTier().ordinal() - 2) {
            return false;
        }
        return this.input.test(modifierStack);
    }

    public boolean matchesTool(ItemStack toolStack, boolean ignoreInfused) {
        if (!this.center.test(toolStack)) {
            return false;
        }
        if (!ignoreInfused) {
            return !toolStack.m_41782_() || !toolStack.m_41783_().m_128471_("ForceInfused");
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return height == 1 && width < 8;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean hasOutput() {
        return !this.output.m_41619_();
    }

    public ItemStack assemble(InfuserBlockEntity inv, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ForceRecipes.INFUSER_TYPE.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getCenter() {
        return this.center;
    }

    public InfuserModifierType getModifier() {
        return this.resultModifier;
    }

    public void setModifier(InfuserModifierType modifier) {
        this.resultModifier = modifier;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.center);
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ForceRecipeSerializers.INFUSER_SERIALIZER.get();
    }

    public static boolean addRecipe(InfuseRecipe recipe) {
        ResourceLocation id = recipe.m_6423_();
        if (HASHES.contains(id.toString())) {
            return false;
        }
        int thisTier = recipe.getTier().ordinal();
        if (!RECIPESBYLEVEL.containsKey(thisTier)) {
            RECIPESBYLEVEL.put(thisTier, new ArrayList());
        }
        RECIPESBYLEVEL.get(thisTier).add(recipe);
        HASHES.add(id.toString());
        ForceCraft.LOGGER.info("Recipe loaded {} -> {} , {}", (Object)id.toString(), (Object)recipe.resultModifier, (Object)recipe.input.m_43942_());
        return true;
    }

    public static class SerializeInfuserRecipe
    implements RecipeSerializer<InfuseRecipe> {
        public InfuseRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            InfuseRecipe recipe = null;
            try {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
                Ingredient center = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"center"));
                String result = GsonHelper.m_13906_((JsonObject)json, (String)"result");
                InfuserModifierType modifier = InfuserModifierType.valueOf(result.replace("forcecraft:", "").toUpperCase());
                ItemStack output = ItemStack.f_41583_;
                if (modifier == InfuserModifierType.ITEM && GsonHelper.m_13900_((JsonObject)json, (String)"output")) {
                    output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
                }
                int tier = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
                recipe = new InfuseRecipe(recipeId, center, ingredient, modifier, UpgradeBookTier.values()[tier], output);
                recipe.setTime(GsonHelper.m_13927_((JsonObject)json, (String)"time"));
                InfuseRecipe.addRecipe(recipe);
                return recipe;
            }
            catch (Exception e) {
                ForceCraft.LOGGER.error("Error loading recipe " + recipeId, (Throwable)e);
                return null;
            }
        }

        public InfuseRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient center = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int enumlon = buffer.m_130242_();
            int tier = buffer.readInt();
            InfuseRecipe r = new InfuseRecipe(recipeId, center, ing, InfuserModifierType.values()[enumlon], UpgradeBookTier.values()[tier], buffer.m_130267_());
            r.setTime(buffer.readInt());
            InfuseRecipe.addRecipe(r);
            return r;
        }

        public void toNetwork(FriendlyByteBuf buffer, InfuseRecipe recipe) {
            recipe.center.m_43923_(buffer);
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.resultModifier.ordinal());
            buffer.writeInt(recipe.getTier().ordinal());
            buffer.m_130055_(recipe.m_8043_(null));
            buffer.writeInt(recipe.getTime());
        }
    }
}

