/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu.furnace;

import com.mrbysco.forcecraft.blockentities.AbstractForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.menu.furnace.slot.ForceFurnaceFuelSlot;
import com.mrbysco.forcecraft.menu.furnace.slot.ForceFurnaceResultSlot;
import com.mrbysco.forcecraft.menu.furnace.slot.UpgradeSlot;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractForceFurnaceMenu
extends AbstractContainerMenu {
    private AbstractForceFurnaceBlockEntity tile;
    private IItemHandler furnaceInventory;
    private IItemHandler upgradeInventory;
    private ContainerData furnaceData;
    private Level level;

    public AbstractForceFurnaceMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, AbstractForceFurnaceMenu.getTileEntity(playerInventory, data));
    }

    protected static AbstractForceFurnaceBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof AbstractForceFurnaceBlockEntity) {
            return (AbstractForceFurnaceBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public AbstractForceFurnaceMenu(int id, Inventory playerInventoryIn, AbstractForceFurnaceBlockEntity te) {
        super((MenuType)ForceMenus.FORCE_FURNACE.get(), id);
        this.tile = te;
        final Player player = playerInventoryIn.f_35978_;
        this.level = player.m_9236_();
        this.furnaceInventory = this.tile.handler;
        this.upgradeInventory = this.tile.upgradeHandler;
        this.furnaceData = this.tile.getFurnaceData();
        this.assertFurnaceSize(this.furnaceInventory, 3);
        this.assertFurnaceSize(this.upgradeInventory, 1);
        AbstractForceFurnaceMenu.m_38886_((ContainerData)this.furnaceData, (int)4);
        this.m_38897_((Slot)new SlotItemHandler(this.furnaceInventory, 0, 56, 17));
        this.m_38897_((Slot)new ForceFurnaceFuelSlot(this, this.furnaceInventory, 1, 56, 53));
        this.m_38897_((Slot)new ForceFurnaceResultSlot(player, this.furnaceInventory, 2, 116, 35){

            @Override
            protected void m_5845_(ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, this.removeCount);
                if (player instanceof ServerPlayer) {
                    AbstractForceFurnaceMenu.this.tile.awardUsedRecipesAndPopExperience((ServerPlayer)player);
                }
                this.removeCount = 0;
                ForgeEventFactory.firePlayerSmeltedEvent((Player)player, (ItemStack)stack);
            }
        });
        this.m_38897_((Slot)new UpgradeSlot(this.upgradeInventory, 0, 12, 12));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.furnaceData);
    }

    public int getBurn() {
        return this.furnaceData.m_6413_(0);
    }

    protected void assertFurnaceSize(IItemHandler inventoryIn, int minSize) {
        int i = inventoryIn.getSlots();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.tile.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(itemstack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != 1 && index != 0) {
                if (this.hasRecipe(itemstack1)) {
                    if (!this.m_38903_(itemstack1, 0, 1, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.isFuel(itemstack1)) {
                    if (!this.m_38903_(itemstack1, 1, 2, false)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    if (AbstractForceFurnaceMenu.isUpgrade(itemstack1) && index == 3) {
                        itemstack1.m_41774_(1);
                        playerIn.m_9236_().m_5594_((Player)null, playerIn.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        return ItemStack.f_41583_;
                    }
                    if (index >= 4 && index < 31 ? !this.m_38903_(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.m_38903_(itemstack1, 4, 31, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(itemstack1, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.level.m_7465_().m_44015_(this.getRecipeType(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    protected RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        RecipeType recipeType = RecipeType.f_44108_;
        ItemStack upgrade = this.upgradeInventory.getStackInSlot(0);
        if (!upgrade.m_41619_()) {
            if (upgrade.m_41720_() == ForceRegistry.FREEZING_CORE.get()) {
                return (RecipeType)ForceRecipes.FREEZING.get();
            }
            if (upgrade.m_41720_() == ForceRegistry.GRINDING_CORE.get()) {
                return (RecipeType)ForceRecipes.GRINDING.get();
            }
        }
        return recipeType;
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractForceFurnaceBlockEntity.isFuel(stack);
    }

    public static boolean isUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof UpgradeCoreItem;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (clickTypeIn == ClickType.PICKUP_ALL && this.m_142621_().m_41720_() instanceof UpgradeCoreItem) {
            return;
        }
        if (slotId == 3 && (slot = this.m_38853_(slotId)).m_6657_() && clickTypeIn != ClickType.QUICK_MOVE) {
            player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.furnaceData.m_6413_(2);
        int j = this.furnaceData.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled() {
        int i = this.furnaceData.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.furnaceData.m_6413_(0) * 13 / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.furnaceData.m_6413_(0) > 0;
    }
}

