/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.magnet.IMagnet;
import com.mrbysco.forcecraft.capabilities.magnet.MagnetCapability;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class MagnetGloveItem
extends BaseItem {
    public MagnetGloveItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_MAGNET == null) {
            return null;
        }
        return new MagnetCapability();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_6144_()) {
            ItemStack stack = playerIn.m_21120_(handIn);
            stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).ifPresent(cap -> {
                boolean state = cap.isActivated();
                cap.setActivation(!state);
                level.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            });
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        IMagnet magnetCap;
        if (entityIn instanceof Player && !(entityIn instanceof FakePlayer) && itemSlot >= 0 && itemSlot <= Inventory.m_36059_() && (magnetCap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null)) != null && magnetCap.isActivated()) {
            ((Player)entityIn).m_7292_(new MobEffectInstance((MobEffect)ForceEffects.MAGNET.get(), 20, 1, true, false));
        }
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IMagnet cap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = MagnetCapability.writeNBT(cap);
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IMagnet cap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            MagnetCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        MagnetCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }
}

