/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EntityFlaskItem
extends BaseItem {
    public EntityFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        Player playerIn = context.m_43723_();
        if (level.f_46443_) {
            return InteractionResult.FAIL;
        }
        if (this.hasEntityStored(stack)) {
            Entity storedEntity = this.getStoredEntity(stack, level);
            BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
            storedEntity.m_19890_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_(storedEntity);
            CompoundTag tag = stack.m_41784_();
            tag.m_128473_("StoredEntity");
            tag.m_128473_("EntityData");
            stack.m_41751_(tag);
        } else {
            playerIn.m_213846_((Component)Component.m_237115_((String)"item.entity_flask.empty2").m_130940_(ChatFormatting.RED));
        }
        stack.m_41774_(1);
        ItemStack emptyFlask = new ItemStack((ItemLike)ForceRegistry.FORCE_FLASK.get());
        if (!playerIn.m_150109_().m_36054_(emptyFlask)) {
            playerIn.m_5552_(emptyFlask, 0.0f);
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (!this.hasEntityStored(itemstack)) {
                level.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12437_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
                if (!level.f_46443_) {
                    FlaskEntity flaskEntity = new FlaskEntity(level, (LivingEntity)playerIn);
                    flaskEntity.m_37446_(itemstack);
                    flaskEntity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
                    level.m_7967_((Entity)flaskEntity);
                }
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.entity_flask.empty").m_130940_(ChatFormatting.RED));
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public boolean hasEntityStored(ItemStack stack) {
        return stack.m_41784_().m_128441_("StoredEntity");
    }

    public Entity getStoredEntity(ItemStack stack, Level level) {
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_("StoredEntity")));
        if (type != null) {
            Entity entity = type.m_20615_(level);
            entity.m_20258_(stack.m_41783_().m_128469_("EntityData"));
            return entity;
        }
        return null;
    }

    public void storeEntity(ItemStack stack, LivingEntity livingEntity) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("StoredEntity", EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString());
        CompoundTag entityTag = new CompoundTag();
        livingEntity.m_20240_(entityTag);
        tag.m_128365_("EntityData", (Tag)entityTag);
        stack.m_41751_(tag);
        livingEntity.m_146870_();
    }

    public boolean isBlacklisted(LivingEntity livingEntity) {
        return ForceTags.FLASK_BLACKLIST_LOOKUP.contains(livingEntity.m_6095_());
    }

    public Component m_7626_(ItemStack stack) {
        if (this.hasEntityStored(stack)) {
            return Component.m_237110_((String)super.m_5671_(stack), (Object[])new Object[]{stack.m_41783_().m_128461_("StoredEntity")});
        }
        return Component.m_237110_((String)super.m_5671_(stack), (Object[])new Object[]{"Empty"});
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        if (this.hasEntityStored(stack)) {
            CompoundTag tag = stack.m_41784_();
            tooltip.add((Component)Component.m_237115_((String)"item.entity_flask.tooltip").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.format("[%s]", tag.m_128461_("StoredEntity"))).m_130940_(ChatFormatting.GRAY)));
            if (tag.m_128441_("EntityData")) {
                tooltip.add((Component)Component.m_237115_((String)"item.entity_flask.tooltip2").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.format("[%s]", tag.m_128469_("EntityData").m_128459_("Health"))).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }
}

