/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.SpoilsBagMenu;
import com.mrbysco.forcecraft.registry.ForceTables;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SpoilsBagItem
extends BaseItem {
    private final int tier;

    public SpoilsBagItem(Item.Properties properties, int tier) {
        super(properties.m_41487_(1));
        this.tier = tier;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IItemHandler tileInventory;
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        this.populateBag(level, stack);
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockEntity tile = level.m_7702_(pos);
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler != null && tile != null && tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent() && (tileInventory = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).orElse(null)) != null && handler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)handler;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack bagStack = itemHandler.getStackInSlot(i);
                ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)bagStack, (int)bagStack.m_41613_());
                if (bagStack.m_41619_()) continue;
                remaining = ItemHandlerHelper.insertItem((IItemHandler)tileInventory, (ItemStack)bagStack, (boolean)false);
                itemHandler.setStackInSlot(i, remaining);
            }
            if (ItemHandlerUtils.isEmpty((IItemHandler)itemHandler)) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler != null) {
            this.populateBag(level, stack);
            playerIn.m_5893_(this.getContainer(stack));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    public ResourceLocation getTable() {
        return switch (this.tier) {
            default -> ForceTables.TIER_1;
            case 2 -> ForceTables.TIER_2;
            case 3 -> ForceTables.TIER_3;
        };
    }

    public void populateBag(Level level, ItemStack stack) {
        IItemHandler handler;
        if (!level.f_46443_ && !stack.m_41784_().m_128471_("Filled") && (handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) instanceof ItemStackHandler && ItemHandlerUtils.isEmpty(handler)) {
            ObjectArrayList lootStacks;
            CompoundTag tag = stack.m_41784_();
            Object stacks = new ArrayList();
            do {
                LootParams.Builder lootParams;
                LootTable table;
                if ((lootStacks = (table = level.m_7654_().m_278653_().m_278676_(this.getTable())).m_287195_((lootParams = new LootParams.Builder((ServerLevel)level)).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    return;
                }
                Collections.shuffle(lootStacks);
            } while ((stacks = lootStacks).isEmpty());
            if (stacks.size() > 7) {
                int newSize = Math.min(8, Math.max(5, level.f_46441_.m_188503_(stacks.size())));
                if (stacks.size() < newSize) {
                    newSize = stacks.size();
                }
                ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
                for (int i = 0; i < newSize; ++i) {
                    newStacks.add((ItemStack)stacks.get(i));
                }
                stacks = newStacks;
            }
            ItemStackHandler stackhandler = (ItemStackHandler)handler;
            for (int i = 0; i < stacks.size(); ++i) {
                stackhandler.setStackInSlot(i, (ItemStack)stacks.get(i));
            }
            tag.m_128379_("Filled", true);
            stack.m_41751_(tag);
        }
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack) {
        return new SimpleMenuProvider((id, inventory, player) -> new SpoilsBagMenu(id, inventory, stack), (Component)(stack.m_41788_() ? ((MutableComponent)stack.m_41786_()).m_130940_(ChatFormatting.BLACK) : Component.m_237115_((String)"forcecraft.container.spoils_bag")));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        IItemHandler handler;
        if (!level.f_46443_ && stack.m_41782_() && stack.m_41783_().m_128471_("Filled") && ItemHandlerUtils.isEmpty(handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null))) {
            stack.m_41774_(1);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)Component.m_237113_((String)("Tier: " + this.tier)).m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryProvider();
    }

    private static class InventoryProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(8){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }
        });

        private InventoryProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.inventory.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            if (this.inventory.isPresent()) {
                return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
            }
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
        }
    }
}

