/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.capabilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.ForcePackMenu;
import com.mrbysco.forcecraft.storage.PackStorage;
import com.mrbysco.forcecraft.storage.StorageManager;
import com.mrbysco.forcecraft.storage.WSDCapability;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ForcePackItem
extends BaseItem {
    public static final String SLOTS_TOTAL = "SlotsTotal";
    public static final String SLOTS_USED = "SlotsUsed";

    public ForcePackItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (level.f_46443_) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!level.f_46443_) {
            PackStorage data = StorageManager.getOrCreatePack(stack);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this.getContainer(stack, data.getInventory()), buf -> buf.writeInt(data.getInventory().getUpgrades()));
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack, PackItemStackHandler handler) {
        return new SimpleMenuProvider((id, playerInv, player) -> new ForcePackMenu(id, playerInv, handler), (Component)(stack.m_41788_() ? ((MutableComponent)stack.m_41786_()).m_130940_(ChatFormatting.BLACK) : Component.m_237115_((String)"forcecraft.container.pack")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(SLOTS_USED) && tag.m_128441_(SLOTS_TOTAL)) {
            tooltip.add((Component)Component.m_237113_((String)String.format("%s/%s Slots", tag.m_128451_(SLOTS_USED), tag.m_128451_(SLOTS_TOTAL))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"0/8 Slots"));
        }
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("uuid")) {
            UUID uuid = stack.m_41783_().m_128342_("uuid");
            tooltip.add((Component)Component.m_237113_((String)("ID: " + uuid.toString().substring(0, 8))).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public Component m_7626_(ItemStack stack) {
        return ((MutableComponent)super.m_7626_(stack)).m_130940_(ChatFormatting.YELLOW);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new WSDCapability(stack);
    }
}

